/** Beispiel SD Card I/O
*/
#include "mbed.h"
#include "SDFileSystem.h"

// Standard SD Card Slot auf FRDM-K64F Board
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS

// File I/O
FILE *fp;

// Sensor
AnalogIn poti( A0 );
char filename[] = "/sd/poti.txt";

/**
 * Sensordaten schreiben, bzw. in Datei anfuegen
 * @param name Name Sensor
 * @param value Sensorwert
 * @return -1 bei Fehler
 */
int writeSensorData( char name[], float value )
{
    // Datei oeffen und anfuegen, Alternative "w" fuer neu schreiben.
    fp = fopen( name, "a" );
    
    // Fehler?
    if (fp == NULL)
        return  ( -1 );

    fprintf( fp, "%f\n", value );
    printf( "write %s: %f\n", name, value );
    fclose ( fp );
    return  ( 0 );
}

/**
 * Sensordaten lesen
 * @param name Name Sensor
 * @return -1 bei Fehler
 */
int readSensorData( char name[] )
{
    fp = fopen( name, "r");
    
    // Fehler?
    if (fp == NULL)
        return  ( -1 );
        
    float value;        
    while   ( fscanf( fp, "%f", &value ) > 0 )
        printf( "read - %s: %f\n", name, value );
        
    fclose ( fp );
    return  ( 0 );
}

/** Hauptprogramm */
int main()
{
    printf("SD Card I/O \n");
    while   ( 1 )
    {
        // 10 x Sensordaten schreiben
        for ( int i = 0; i < 10; i++ )
        {
            writeSensorData( filename, poti.read() );
            wait ( 1.0f );
        }
        
        // Sensordaten lesen
        readSensorData( filename );
        wait ( 1.0f );
        remove( filename );
    }
}
