/** 6.4 Motor mittels Tasten vor-, rückwärts, Stop laufen lassen und Poti benützen um die Geschwindigkeit einzustellen.
    Erweitert um Abstandssensor wo vor einem Hindernis stoppt.
*/

#include "mbed.h"
#include "Motor.h"
#include "ultrasonic.h"

// vor-/rueckwaerts - beide = Notstop
DigitalIn button1( A1 );
DigitalIn button2( A2 );

// Geschwindigkeit
AnalogIn poti ( A0 );

// Motor an M01
Motor m1(D3, D2, D4); // PWM, Vorwaerts, Rueckwarts

// aktueller Abstand                                        
int distance;                                                                                

void dist(int d)
{
    // Abhandlung der Entfernung
    printf("Entfernung %dmm\n", d);
    distance = d;
}

ultrasonic mu(D5, D6, .1, 1, &dist);    // setzt den Trigger Pin auf D5, den Echo Pin auf D6
                                        // liefert all 0.1 Sekunden einen neuen Wert mit einem
                                        // Timeout von 1 Sekunden. Fuer die Ausgabe des Wertes
                                        // wird die Funktion dist aufgerufen.

/** Hauptprogramm */
int main()
{
    mu.startUpdates();                  // Start der Abstandsmessung
    while (true) 
    {
        if  ( button1 == 0 && button2 == 0 )
            m1.speed( 0.0f );
        else if ( button1 == 0 )
            m1.speed( poti );
        else if ( button2 == 0 )
            m1.speed( poti * -1.0f );

        mu.checkDistance();             // Pooling vom Distanzmesser, sollte moeglichst oft erfolgen
        // 70 mm vor einem Hindernis - Stopp!
        if  ( distance < 70 )
            m1.speed( 0.0f );
                       
        wait(0.2f);
    }
}