#include "stdafx.h"
#include "functions.h"

void modeProcess()
{
    temp_measure = temp_cal();
    if (modeStatus) {
        fanLevel_dis = fan_cal(temp_measure);
        lightLevel_dis = light_cal();
    } else {
        fanLevel_dis = fanLevel_man;
        lightLevel_dis = lightLevel_man;
    }
    setPWM(fanLevel_dis);
    setLED(lightLevel_dis);
}
float temp_cal()
{
    float a[10], tempC, sum = 0;
    int i;
    for(i = 0; i < 10; i++) {
        a[i] = temp_sen.read();
        wait(.05);
        sum += a[i];
    }
    tempC=sum*3.3*10;
    //tempF=(9.0*tempC)/5.0 + 32.0;
    return tempC;
}

int light_cal()
{
    float vl[10], vol, sum = 0;
    int i, lvl;
    for (i = 0; i < 10; i++) {
        vl[i] = light_sen.read();
        wait(.05);
        sum += vl[i];
    }
    //output voltage of light sensor
    vol = sum*3.3*10;
    if ((vol > 0) && (vol <= 66)) {
        lvl = 0;
    } else if ((vol > 66) && (vol <= 132)) {
        lvl = 1;
    } else if ((vol > 132) && (vol <= 198)) {
        lvl = 2;
    } else if ((vol > 198) && (vol <= 264)) {
        lvl = 3;
    } else {
        lvl = 4;
    }
    return lvl;
}

int fan_cal(int &temp)
{
    int speed;
    int range = (high - low)/3;
    int mid1 = low + range;
    int mid2 = high - range;
    if (temp <= low) {
        speed = 0;
    } else if ((temp > low) && (temp <= mid1)) {
        speed = 1;
    } else if ((temp > mid1) && (temp <= mid2)) {
        speed = 2;
    } else if ((temp > mid2) && (temp <= high)) {
        speed = 3;
    } else {
        speed = 4;
    }
    return speed;
}

void setLED(int &light_value)
{
    if (light_value == 0) {
        led_o.period(0.01);
        led_o.write(1);
    } else if (light_value == 1) {
        led_o.period(0.01);
        led_o.write(0.75);
    } else if (light_value == 2) {
        led_o.period(0.01);
        led_o.write(0.5);
    } else if (light_value == 3) {
        led_o.period(0.01);
        led_o.write(0.25);
    } else {
        led_o.period(0.1);
        led_o.write(0);
    }
}

void setPWM(int &speed)
{
    if (speed == 4) {
        pwm.period(0);
        pwm.write(0);
    } else if (speed == 3) {
        pwm.period(1);
        pwm.write(0.25);
    } else if (speed == 2) {
        pwm.period(1);
        pwm.write(0.5);
    } else if (speed == 1) {
        pwm.period(1);
        pwm.write(0.75);
    } else {
        pwm.period(1);
        pwm.write(1);
    }
}

void buttonEnter()
{
    if ((enter == 0) && (state == 0)) {
        state = 1;
        wait(0.2);
    }
    if ((enter == 0) && (state == 1) && (type == 0)) {
        type = 1;
        wait(0.2);
    }
    if ((enter == 0) && (state == 1) && (type == 1)) {
        state = 2;
        type = 0;
        wait(0.2);
    }
    if ((enter == 0) && (state == 1) && (type == 2)) {
        state = 3;
    }
    if ((enter == 0) && (state == 1) && (type == 3)) {
        state = 4;
    }
    if ((enter == 0) && (state == 1) && (type == 4)) {
        state = 5;
        type = 0;
    }
    if ((enter == 0) && (state == 2) && (type == 0)) {
        type = 1;
        wait(0.2);
    }
    if ((enter == 0) && (state == 2) && (type == 1)) {
        type = 2;
        wait(0.2);
    }
    if ((enter == 0) && (state == 2) && (type == 2)) {
        type = 1;
        wait(0.2);
    }
    if ((enter == 0) && (state == 5) && (type == 0)) {
        type = 1;
        modeStatus = !modeStatus;
    }
    if ((enter == 0) && (state == 5) && (type == 1)) {
        modeStatus = !modeStatus;
    }
}

void buttonBack()
{
    if ((back == 0) && (state == 1) && (type == 0)) {
        state = 0;
        type = 0;
        wait(0.2);
    }
    if ((back == 0) && (state == 1) && ((type == 1) || (type == 2) || (type == 3) || (type == 4))) {
        state = 1;
        type = 0;
        wait(0.2);
    }
    if ((back == 0) && (state == 2) && (type == 0)) {
        state = 1;
        // type = 1;
        wait(0.2);
    }
    if ((back == 0) && (state == 2) && ((type == 1) || (type == 2))) {
        state = 2;
        type = 0;
        wait(0.2);
    }
    if ((back == 0) && (state == 3)) {
        state = 1;
        type = 2;
        wait(0.2);
    }
    if ((back == 0) && (state == 4)) {
        state = 1;
        type = 3;
        wait(0.2);
    }
    if ((back == 0) && (state == 5)) {
        state = 1;
        type = 4;
        wait(0.2);
    }
}

void buttonUp()
{
    if ((up == 0) && (state == 1) && (type == 0)) {
        type = 1;
        wait(0.2);
    }
    if ((up == 0) && (state == 1) && (type == 1)) {
        type = 2;
        wait(0.2);
    }
    if ((up == 0) && (state == 1) && (type == 2)) {
        type = 3;
        wait(0.2);
    }
    if ((up == 0) && (state == 1) && (type == 3)) {
        type = 4;
        wait(0.2);
    }
    if ((up == 0) && (state == 2) && (type == 1)) {
        low++;
    }
    if ((up == 0) && (state == 2) && (type == 2)) {
        high++;
    }
    if ((up == 0) && (state == 3)) {
        if (lightLevel_man < 4) {
            lightLevel_man++;
        }
    }
    if ((up == 0) && (state == 4)) {
        if (fanLevel_man < 4) {
            fanLevel_man++;
        }
    }
}

void buttonDown()
{
    if ((down == 0) && (state == 1) && (type == 4)) {
        type = 3;
        wait(0.2);
    }
    if ((down == 0) && (state == 1) && (type == 3)) {
        type = 2;
        wait(0.2);
    }
    if ((down == 0) && (state == 1) && (type == 2)) {
        type = 1;
        wait(0.2);
    }
    if ((down == 0) && (state == 1) && (type == 1)) {
        type = 0;
        wait(0.2);
    }
    if ((down == 0) && (state == 2) && (type == 1)) {
        low--;
    }
    if ((down == 0) && (state == 2) && (type == 2)) {
        high--;
    }
    if ((down == 0) && (state == 3)) {
        if (lightLevel_man > 0) {
            lightLevel_man--;
        }
    }
    if ((down == 0) && (state == 4)) {
        if (fanLevel_man > 0) {
            fanLevel_man--;
        }
    }
}

void mainScreen()
{
    modeProcess();
    buttonEnter();
    lcd.cls();
    lcd.printf("T %i  L %i  F %i \n",temp_measure, lightLevel_dis, fanLevel_dis);
    if (modeStatus) {
        lcd.printf("Auto mode: ON\n");
    } else {
        lcd.printf("Auto mode: OFF\n");
    }
    wait(0.2);
}
void optionScreen()
{
    if(type == 0) {
        lcd.cls();
        lcd.printf("  Set Temp\n");
        lcd.printf("  Set Light");
        wait(0.2);
        buttonBack();
        buttonUp();
    }
    if (type == 1) {
        buttonEnter();
        buttonUp();
        buttonDown();
        buttonBack();
        lcd.cls();
        lcd.printf("o Set Temp\n");
        lcd.printf("  Set Light");
        wait(0.2);
    }
    if (type == 2) {
        lcd.cls();
        lcd.printf("  Set Temp\n");
        lcd.printf("o Set Light");
        wait(0.2);
        buttonEnter();
        buttonUp();
        buttonDown();
        buttonBack();
    }
    if (type == 3) {
        lcd.cls();
        lcd.printf("o Set Fan\n");
        lcd.printf("  Set Mode");
        wait(0.2);
        buttonEnter();
        buttonUp();
        buttonDown();
        buttonBack();
    }
    if (type == 4) {
        lcd.cls();
        lcd.printf("  Set Fan\n");
        lcd.printf("o Set Mode");
        wait(0.2);
        buttonEnter();
        buttonUp();
        buttonDown();
        buttonBack();
    }
}

void temperatureScreen()
{
    if (type == 0) {
        lcd.cls();
        lcd.printf("Temp setup\n");
        lcd.printf(" Low:%i  High:%i", low, high);
        wait(0.2);
        buttonEnter();
        buttonBack();
    }
    if (type == 1)  {
        lcd.cls();
        lcd.printf("Temp setup\n");
        lcd.printf("oLow:%i  High:%i", low, high);
        wait(0.2);
        buttonEnter();
        buttonUp();
        buttonDown();
        buttonBack();
    }
    if (type == 2) {
        lcd.cls();
        lcd.printf("Temp setup\n");
        lcd.printf(" Low:%i oHigh:%i", low, high);
        wait(0.2);
        buttonEnter();
        buttonUp();
        buttonDown();
        buttonBack();
    }
}

void lightScreen()
{
    lcd.cls();
    lcd.printf("Light setup\n");
    lcd.printf("Brightness: %i", lightLevel_man);
    wait(0.2);
    buttonUp();
    buttonDown();
    buttonBack();
}

void fanScreen()
{
    lcd.cls();
    lcd.printf("Fan setup\n");
    lcd.printf("Speed: %i", fanLevel_man);
    wait(0.2);
    buttonUp();
    buttonDown();
    buttonBack();
}
void modeScreen()
{
    lcd.cls();
    lcd.printf("Mode setup\n");
    if (modeStatus) {
        lcd.printf("Auto: ON");
    } else {
        lcd.printf("Auto: OFF");
    }
    wait(0.2);
    buttonEnter();
    buttonBack();
}
