#include "mbed.h"

#ifndef WS2812_H
#define WS2812_H

#define WS2812_LED_NUM_LEDS 30
#define WS2812_LED_NUM_RESET_BYTES 3

typedef struct
{
  uint8_t r;
  uint8_t g;
  uint8_t b;
} Color;
 
class WS2812 {
public:
    WS2812(SPI &spi, event_callback_t led_update_strip_finished);
    
    void update_strip();
    void set_led(int led_number, Color *c);
    void set_all(Color *c);

private:
    SPI _spi;
    int _led_data_size;
    event_callback_t _led_update_strip_finished;
    
    void _write_color_to_memory(uint8_t* tuple, uint8_t color_value);
    
    // Each sent bit to the LED strip is represented by 4 bits in memory.
    // Each LED requires 24 bits (8 bits per color).
    // In addition, we need to allocate room to send enough zeros so that the strip latches
    uint8_t _led_data[WS2812_LED_NUM_LEDS*12 + WS2812_LED_NUM_RESET_BYTES];
};

#endif