#include "mbed.h"
#include "WS2812.h"

LowPowerTicker toggleTicker;

Color color_red = {255, 0, 0};
Color color_green = {0, 255, 0};
Color color_blue = {0, 0, 255};
Color color_black = {0,0,0};

bool update_led_flag;
bool ledstrip_busy;
int state = 0;

void update(void) {
    update_led_flag = true;
}

void send_complete(int event) {
    (void)event;
    ledstrip_busy = false;
}

event_callback_t callback;

int main(void) {

    SPI spi(PE10, NC, PE12);
    
    callback.attach(send_complete);
    
    WS2812 ledstrip(spi, callback);
    
    toggleTicker.attach(&update, 1.0f);

    while(1) {
        sleep();
        if(update_led_flag)
        {
            update_led_flag=false;
            switch(state){
                case 0:
                    ledstrip.set_all(&color_green);
                    state++;
                    break;
                case 1:
                    ledstrip.set_all(&color_blue);
                    state++;
                    break;
                case 2:
                    ledstrip.set_all(&color_red);
                    state=0;
                    break;
            }
            ledstrip_busy = true;
            ledstrip.update_strip();
        }
    }
}