#include "BMP085.h"

LowPowerTicker ticker;

bool do_measurement = false;
void measurement() {
    do_measurement = true;
}

int main() {
    BMP085 sensor(PD6, PD7, BMP085_MODE_HIGH_RESOLUTION);
    ticker.attach(&measurement, 0.4);    
    
    while(1) {
        sleep();
        if(do_measurement) {
            do_measurement = false;
            sensor.measure();
            printf("T: %6.2f, P: %6.4f\r\n  ", sensor.get_temperature(), sensor.get_pressure());
        }
    }
}