#include "BMP085.h"

void BMP085::init(void) {
    _callback.attach(this, &BMP085::_callback_handler);
    
    _cal_data.ac1 = read_cal_register(BMP085_CAL_AC1);
    _cal_data.ac2 = read_cal_register(BMP085_CAL_AC2);
    _cal_data.ac3 = read_cal_register(BMP085_CAL_AC3);
    _cal_data.ac4 = read_cal_register(BMP085_CAL_AC4);
    _cal_data.ac5 = read_cal_register(BMP085_CAL_AC5);
    _cal_data.ac6 = read_cal_register(BMP085_CAL_AC6);
    _cal_data.b1 = read_cal_register(BMP085_CAL_B1);
    _cal_data.b2 = read_cal_register(BMP085_CAL_B2);
    _cal_data.mb = read_cal_register(BMP085_CAL_MB);
    _cal_data.mc = read_cal_register(BMP085_CAL_MC);
    _cal_data.md = read_cal_register(BMP085_CAL_MD);
}

uint16_t BMP085::read_cal_register(BMP085_Register reg) {
    _tx_buf[0] = reg;
    _state = BMP085_BUSY;
    _i2c.transfer(BMP085_ADDR, (char*)_tx_buf, 1, (char*)_rx_buf, 2, _callback);
    while(_state != BMP085_IDLE) {
        sleep();
    }
    return (_rx_buf[0] << 8) | _rx_buf[1];
}

uint16_t BMP085::read_uc_temperature(void) {
    LowPowerTimeout delay;
    _tx_buf[0] = BMP085_CTRL;
    _tx_buf[1] = BMP085_CMD_READ_TEMP;
    _state = BMP085_BUSY;
    _i2c.transfer(BMP085_ADDR, (char*)_tx_buf, 2, (char*)NULL, 0, _callback);
    while(_state != BMP085_IDLE) {
        sleep();
    }

    _state = BMP085_BUSY;
    delay.attach(this, &BMP085::_callback_handler, 0.01);
    while(_state != BMP085_IDLE) {
        sleep();
    }

    _tx_buf[0] = BMP085_DATA_TEMP;
    _state = BMP085_BUSY;
    _i2c.transfer(BMP085_ADDR, (char*)_tx_buf, 1, (char*)_rx_buf, 2, _callback);
    while(_state != BMP085_IDLE) {
        sleep();
    }
    return (_rx_buf[0] << 8) | _rx_buf[1];
}

uint32_t BMP085::read_uc_pressure(void) {
    LowPowerTimeout delay;
    _tx_buf[0] = BMP085_CTRL;
    _tx_buf[1] = BMP085_CMD_READ_PRESSURE + ((uint8_t)_mode << 6);
    _state = BMP085_BUSY;
    _i2c.transfer(BMP085_ADDR, (char*)_tx_buf, 2, (char*)NULL, 0, _callback);
    while(_state != BMP085_IDLE) {
        sleep();
    }

    _state = BMP085_BUSY;
    delay.attach(this, &BMP085::_callback_handler, 0.02);
    while(_state != BMP085_IDLE) {
        sleep();
    }

    _tx_buf[0] = BMP085_DATA_PRESSURE;
    _state = BMP085_BUSY;
    _i2c.transfer(BMP085_ADDR, (char*)_tx_buf, 1, (char*)_rx_buf, 3, _callback);
    while(_state != BMP085_IDLE) {
        sleep();
    }
    return ((_rx_buf[0] << 16) | (_rx_buf[1] << 8) | _rx_buf[2]) >> (8 - (uint8_t)_mode);    
}

void BMP085::measure() {
    int t, p, ut, up, x1, x2, x3, b3, b5, b6;
    uint32_t b4, b7;

    ut = read_uc_temperature();

    x1 = (ut - _cal_data.ac6) * _cal_data.ac5 / (1 << 15);
    x2 = (int)_cal_data.mc * (1 << 11) / (x1 + _cal_data.md);
    b5 = x1 + x2;
    t = (b5 + 8) / (1 << 4);
    _temperature = (float)t / 10.0;
    
    up = read_uc_pressure();
    
    b6 = b5 - 4000;
    x1 = (_cal_data.b2 * (b6 * b6 / (1 << 12))) / (1 << 11);
    x2 = _cal_data.ac2 * b6 / (1 << 11);
    x3 = x1 + x2;
    b3 = ((((unsigned int)_cal_data.ac1 * 4 + x3) << (int)_mode) + 2) / 4;
    x1 = _cal_data.ac3 * b6 / (1 << 13);
    x2 = (_cal_data.b1 * (b6 * b6 / (1 << 12))) / (1 << 16);
    x3 = ((x1 + x2) + 2) / (1 << 2);
    b4 = _cal_data.ac4 * (unsigned int)(x3 + 32768) / (1 << 15);
    b7 = ((unsigned int)up - b3) * (50000 >> (int)_mode);
    if (b7 < (unsigned int)0x80000000) {
        p = (b7 * 2) / b4;
    } else {
        p = (b7 / b4) * 2;
    }
    x1 = (p / (1 << 8)) * (p / (1 << 8));
    x1 = (x1 * 3038) / (1 << 16);
    x2 = (-7357 * p) / (1 << 16);
    p = p + (x1 + x2 + 3791) / (1 << 4);
    _pressure = (float)p / 100.0;
}

void BMP085::_callback_handler(int event) {
    _state = BMP085_IDLE;
}

void BMP085::_callback_handler() {
    _state = BMP085_IDLE;
}
