/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "C12832.h"
#include "TMP102.h"

TMP102 temperature(D14, D15, 0x90);
C12832 lcd(D11, D13, D12, D7, D10);

int main()
{
    // clear the screen
    lcd.cls();
    
    // print the first line and wait 3 sec
    lcd.locate(0,3);
    lcd.printf("mbed application board!");
    wait(3);

    // print the counter prefix; the number will be printed in the while loop
    lcd.locate(0,15);
    lcd.printf("temp:", temperature.read());
    
    int i=1;
    while(i++) {
        lcd.locate(24,15);
        lcd.printf("%f  ", temperature.read());
        wait(0.2);
    }
}