/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"

BusOut bus1(D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15);
BusOut bus2(A5, A4, A3, A2, A1, A0);
int i, j, l = 15, c = 3, r = 6;
float s = 0.1;
 
int main()
{
    bus1 = bus2 = 0;
    for (i=0; i<=l; i++) {
        bus1 = bus1 + (1 << i | 1 << i+1 | 1 << i+2);
        bus2 = bus2 + (1 << i | 1 << i+1 | 1 << i+2);
        wait(s);
        i=i+2;
    }

    bus1 = bus2 = 0;
    for (j=0; j<c; j++) {
        for (i=0; i<=l; i++) {
            bus1 = bus1 + (1 << i+j);
            bus2 = bus2 + (1 << i+j);
            wait(s);
            i=i+2;
        }
    }

    bus1 = bus2 = 0;
    for (i=0; i<=l; i++) {
        bus1 = bus1 + (1 << i);
        bus2 = bus2 + (1 << i);
        wait(s);
    }
    for (i=0; i<=l; i++) {
        bus1 = bus1 - (1 << i);
        bus2 = bus2 - (1 << i);
        wait(s);
    }
}