/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "MotorDriver.h"

#define MOTORSHIELD_IN1     D8
#define MOTORSHIELD_IN2     D11
#define MOTORSHIELD_IN3     D12
#define MOTORSHIELD_IN4     D13
#define SPEEDPIN_A          D9
#define SPEEDPIN_B          D10

MotorDriver motorDriver(MOTORSHIELD_IN1,MOTORSHIELD_IN2,MOTORSHIELD_IN3,MOTORSHIELD_IN4,SPEEDPIN_A,SPEEDPIN_B);

int main(){
    /*Configure the motor A to control the wheel at the left side.*/
    /*Configure the motor B to control the wheel at the right side.*/
    motorDriver.init();
    motorDriver.setSpeed(90,MOTORB);
    motorDriver.setSpeed(90,MOTORA);
    while(1){
        motorDriver.goForward();
        wait(2);
        motorDriver.goBackward();
        wait(2);
        motorDriver.goLeft();
        wait(2);
        motorDriver.goRight();
        wait(2);
    }   
}