/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "LED_Bar.h"
#include "DigitDisplay.h"

/**
 * RX pin - D0
 * TX pin - D1
 */
DigitDisplay display(D0, D1);
LED_Bar bar(D6, D5);
DigitalOut relay(D4);

AnalogIn lsensor(A0);
AnalogIn pot(A3);

DigitalOut myled(LED1);

int main() {
    float val;
    uint8_t array[4];
    int valnum = 1234;

    // test bar and display first
    bar.setLevel(0);
    display.clear();
    for (int i=0; i<4; i++) {
        for (int j=0; j<10; j++) {
            bar.setLevel(j);
            for (int z=4; z>=3-i; z--) {
                display.write(z, j);
            };
            wait(0.05);
            relay = !relay;
        }
    }
        
    bar.setLevel(0);
    display.clear();
    while(1) {
        // read the sensor data
        val = lsensor.read();
        
        // set bar
        bar.setLevel((int)(val * 10));
        
        // set display
        valnum = (int)(val * 1000);
        for (int i=3; i>=0; i--) {
            array[i] = valnum % 10;
            valnum /= 10;
        }
        display.write(array);
        
        // set relay
        relay = val <= pot ? 1 : 0;
        
        // set LED
        myled = !myled;
        
        wait(0.1);
    }
}
