/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "DigitDisplay.h"

DigitalOut myled(LED1);

/**
 * RX pin - D0
 * TX pin - D1
 */
DigitDisplay display(D0, D1);

Ticker tick;

uint8_t hour   = 20;
uint8_t minute = 14;
uint8_t second = 0;

void beat()
{
    static uint8_t colon = 0;
    
    display.setColon(colon);
    if (colon) {
        second++;
        if (second >= 60) {
            second = 0;
            minute++;
            if (minute >= 60) {
                minute = 0;
                
                hour++;
                if (hour >= 24) {
                    hour = 0;
                }
                display.write(0, hour / 10);
                display.write(1, hour % 10);
            }
            display.write(2, minute / 10);
            display.write(3, minute % 10);
        }
    }
    colon = 1 - colon;
}

int main() {
    display.write(0, hour / 10);
    display.write(1, hour % 10);
    display.write(2, minute / 10);
    display.write(3, minute % 10);
    display.setColon(true);
    tick.attach(&beat, 0.5);
    while(1) {
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
}
