/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "GSM.h"

#define PHONE_NUMBER            "00xxxxxxxxxxxx"

#define SEND_SMS_TEST           0
#define CALL_UP_TEST            1
#define ANSWER_TEST             0
#define READ_SMS_TEST           0

/** On many platforms USBTX/USBRX overlap with serial on D1/D0 pins and enabling the below will interrupt the communication.
 *  You can use an LCD display to print the values or store them on an SD card etc.
 */
Serial pc(USBTX, USBRX);

/**
 * D1 - TX pin (RX on the GSM module side)
 * D0 - RX pin (TX on the GSM module side)
 * 19200 - GSM baud rate
 */
GSM gsm(D1, D0, 19200, PHONE_NUMBER);

void messageHandle(void)
{        
     __disable_irq();
    int messageType = gsm.loopHandle();
    if(MESSAGE_RING == messageType) {
        gsm.answer();
    } else if(MESSAGE_SMS == messageType) {
        char smsMessage[SMS_MAX_LENGTH];
        gsm.getSMS(smsMessage);
    }
    __enable_irq();
}

int main(void)
{
    while(0 != gsm.init()) {
        wait(2);
    }

#if SEND_SMS_TEST
    gsm.sendSMS(PHONE_NUMBER, "Hello from my GPRS shield");
#endif

#if CALL_UP_TEST
    gsm.callUp(PHONE_NUMBER);
#endif

#if ANSWER_TEST || READ_SMS_TEST
    gsm.gsmSerial.attach(&messageHandle);
#endif

    while(1) {
        wait(1);
    }
}
