/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "GPRSInterface.h"

/** On many platforms USBTX/USBRX overlap with serial on D1/D0 pins and enabling the below will interrupt the communication.
 *  You can use an LCD display to print the values or store them on an SD card etc.
 */
//Serial pc(USBTX, USBRX);

/**
 * D1 - TX pin (RX on the WiFi side)
 * D0 - RX pin (TX on the WiFi side)
 * 115200 - Baud rate
 * "apn" - APN name
 * "username" - APN username
 * "password" - APN passowrd
 */
GPRSInterface eth(D1, D0, 115200, "apn", "username", "password");

int main()
{
    wait(3);
    
    // Initialize the interface.
    // If no param is passed to init() then DHCP will be used on connect()
    int s = eth.init();
    if (s != NULL) {
        printf(">>> Could not initialise. Halting!\n");
        exit(0);
    }

    printf(">>> Get IP address...\n");
    while (1) {
        s = eth.connect(); // Connect to network

        if (s == false || s < 0) {
            printf(">>> Could not connect to network. Retrying!\n");
            wait(3);
        } else {
            break;
        }
    }
    printf(">>> Got IP address: %s\n", eth.getIPAddress());

    // Prepare the http request to mbed.org
    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    TCPSocketConnection sock;
    sock.connect("mbed.org", 80);    
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    printf(">>> Sent request to mbed.org\n");

    // Read the response
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf(">>> Received %d chars from mbed.org:\n%s\n", ret, buffer);
    }
    sock.close();
    
    // Disconnect from network
    eth.disconnect();
    return 0;
}
