/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "WIZ820ioInterface.h"

Serial pc(USBTX, USBRX);

/**
 * D11 - MOSI pin
 * D12 - MISO pin
 * D13 - SCK pin
 * D10 - SEL pin
 * NC - Reset pin; use D5 otherwise the shield might get into reset loop
 */
WIZ820ioInterface eth(D11, D12, D13, D10, D5);

int main()
{
    wait(3);
    
    // Initialize the interface.
    // If no param is passed to init() then DHCP will be used on connect()
    int s = eth.init();
    if (s != NULL) {
        printf(">>> Could not initialise. Halting!\n");
        exit(0);
    }

    printf(">>> Get IP address...\n");
    while (1) {
        s = eth.connect(); // Connect to network

        if (s == false || s < 0) {
            printf(">>> Could not connect to network! Retrying ...\n");
            wait(3);
        } else {
            break;
        }
    }
    printf(">>> Got IP address: %s\n", eth.getIPAddress());

    // Prepare the http request to mbed.org
    printf(">>> Open socket to mbed.org:80\n");
    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    TCPSocketConnection sock;
    
    while (sock.connect("mbed.org", 80) == -1) {
        printf(">>> Unable to open socket! Retrying ...\n");
    };
    
    printf(">>> Request %s\n", http_cmd);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    // Read the response
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf(">>> Received %d chars from mbed.org:\n%s\n", ret, buffer);
    }

    printf(">>> Close socket\n");
    sock.close();
    
    // Disconnect from network
    printf(">>> Disconnect from network\n");
    eth.disconnect();

    return 0;
}
