/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "SeeedStudioShieldBot.h"

SeeedStudioShieldBot bot(
    D5, D6, D7,             // Left motor pins
    D8, D9, D10,            // Right motor pins
    A0, A1, A2, A3, D4      // Sensors pins
);
float speed = 0;

int main() {
    bot.enable_right_motor();
    bot.enable_left_motor();

    while(1) {
        bot.stopAll();
        wait(1);
        
        speed = 0;
        while (speed < 1) {
            speed += 0.1f;
            bot.forward(speed);
            wait(1);
        };
        bot.stopAll();
        wait(1);
        
        bot.turn_left(speed);
        wait(1);
        bot.right(speed);
        wait(1);
        bot.stopAll();
        wait(1);
        
        bot.turn_right(speed);
        wait(1);
        bot.left(speed);
        wait(1);
        bot.stopAll();
        wait(1);
    }
}
