//#define COMPILE_EXAMPLE1_CODE_MODSERIAL
#define PC_BAUD 9600
#define BT_BAUD 9600
#define TX_PIN p9
#define RX_PIN p10
#define NUM_SENSORS 7
//#include "MODSERIAL/example1.cpp"

#include "mbed.h"
#include "MODSERIAL.h"

// bluetooth serial

MODSERIAL pc(USBTX, USBRX);
MODSERIAL bt(TX_PIN, RX_PIN);

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

bool newline_detected = false;
bool newline_sent = false;

int intensity[NUM_SENSORS] = {0};
int onTime[NUM_SENSORS] = {0};
int periodTime[NUM_SENSORS] = {0};

// Called everytime a new character goes into
// the RX buffer. Test that character for \n
// Note, rxGetLastChar() gets the last char that
// we received but it does NOT remove it from
// the RX buffer.
void rxCallback(MODSERIAL_IRQ_INFO *q)
{
    MODSERIAL *serial = q->serial;
    if ( serial->rxGetLastChar() == '\n') {
        newline_detected = true;
    }
//    // If it is a heartbeat, respond to it now
//    if( serial->rxGetLastChar() == '?') {
//        bt.putc('?');
//        newline_detected = false;
//    }

}

void txCallback(MODSERIAL_IRQ_INFO *q)
{
    MODSERIAL *serial = q->serial;
    if ( serial->txGetLastChar() == '\0') {
        newline_sent = true;
    }
}

int main()
{
    pc.baud(PC_BAUD);
    bt.baud(BT_BAUD);

    pc.attach(&rxCallback, MODSERIAL::RxIrq);
    bt.attach(&txCallback, MODSERIAL::TxIrq);

    led1 = 0.0f;
    led2 = 0.0f;
    led3 = 0.0f;
    led4 = 0.0f;
    int input = 0;
    int index = 0;
    pc.printf("Master Alive!\n");
    int which = 0;
    int newIntensity =0;
    int newOnTime =0;
    int newPeriodTime = 0;
    int motorNumber = '0';
    
    //init some values
    intensity[which] = 1;        
    onTime[which] = 50;       
    periodTime[which] = 50;
            
    pc.printf("Type: WhichMotor[0-7] Intensity[0-9] OnTime[0-9] PeriodTime[0-9], e.g. 0826 \n");
    while(1) {
        // Wait here until we detect the \n going into the buffer.
        if(newline_detected) {
            newline_detected = false;
            while(pc.readable()) {
                input = pc.getc();
                switch ( index ) {
                    case 0: {
                        motorNumber = input; 
                        which = motorNumber-('0');//set into range from 0 - 9
                        index = (which < 0)? 4 : index;
                        index = (which > (NUM_SENSORS-1))? 4 : index;
                        pc.printf("Sensor: %d  ",which);
                        bt.putc(motorNumber);
                        break;
                    }
                    case 1: {
                        // Intensity
                        newIntensity = input - '0'; //set into range from 0 - 9
                        newIntensity = (newIntensity < 0)? 0 : newIntensity;
                        newIntensity = (newIntensity > 9)? 9 : newIntensity;
                        intensity[which] = ceil((newIntensity+0.0354)*28.222);
                        float intensityFloat = (intensity[which]+253)/508.0;
                        pc.printf("Intensity: %f  ",intensityFloat);
                        bt.putc(intensity[which]);
                        break;
                    }
                    case 2: {
                        // On Time
                        newOnTime = input - '0'; //set into range from 0 - 9
                        newOnTime = (newOnTime < 0)? 0 : newOnTime;
                        newOnTime = (newOnTime > 9)? 9 : newOnTime;
                        onTime[which] = ceil((newOnTime+0.0354)*28.222);
                        int onTimeTransl = floor( ((onTime[which]+49.8)/1.016) + 0.5);
                        pc.printf("onTime: %d  ",onTimeTransl);
                        bt.putc(onTime[which]);
                        break;
                    }
                    case 3: {
                        // Total Period Length
                        newPeriodTime = input - '0'; //set into range from 0 - 9
                        newPeriodTime = (newPeriodTime < 0)? 0 : newPeriodTime;
                        newPeriodTime = (newPeriodTime > 9)? 9 : newPeriodTime;
                        periodTime[which] = ceil((newPeriodTime+0.0354)*28.222);
                        int periodTimeTransl = floor( ((periodTime[which]+19.5946)/0.0686) +0.5);
                        pc.printf("periodTime: %d  ",periodTimeTransl);
                        bt.putc(periodTime[which]);
                        break;
                    }
                    default: {
                        // do nothing
                        break;
                    }
                }
                index++;
            }
            pc.putc('\n');
            bt.putc('\0');
            index = 0;
        }
        else
        {
            bt.putc(motorNumber);
            bt.putc(intensity[which]);        
            bt.putc(onTime[which]);       
            bt.putc(periodTime[which]);
            bt.putc('\0');
        }
        
        wait_ms(400);  
        //led1 = (float) which/3.0;
        //led2 = (float) intensity[which]/255.0;
        //led3 = (float) onTime[which]/255.0;
        //led4 = (float) periodTime[which]/255.0;
        

    }

}