#include "robotLibrary.h"

USBSerial console1; // tx, rx
Serial bt(p9,p10); // tx, rx
char bluetoothData[50];
bool bluetoothConnected;
bool validBluetoothData;

// Read data from the bluetooth
// Stores data in the bluetoothData array
// Messages must end in the null termination character ('\0')
// Will return true if a complete bluetooth message has been received (and thus if the data in bluetoothData is valid)
// This method DOES NOT BLOCK
//   it will read as long as data is available and then stop, whether or not the message is complete
//   at the next call, it will continue reading and adding to the array until '\0' is received
//  Thus, this method is meant to be called once per loop
bool getBluetoothData()
{
  if(validBluetoothData) // reset array
  {
    for(int i = 0; i < 50; i++)
      bluetoothData[i] = '\0';
    validBluetoothData = false;
  }

  if(!bluetoothAvailable())
    return false;

  int index = length(bluetoothData);
  while(bluetoothAvailable() && !validBluetoothData)
  {
    bluetoothData[index++] = getBluetoothChar();
    validBluetoothData = (bluetoothData[index-1] == '\0');
  }
  if(validBluetoothData)
  {
    // If it is a heartbeat, respond to it now
    if(equals(bluetoothData, "?"))
    {
      sendBluetoothData("?");
      bluetoothData[0] = '\0';
      validBluetoothData = false;
      return false;
    }
    robotPrintDebug("Got BT data <"); robotPrintDebug(bluetoothData); robotPrintlnDebug(">\0");
  }
  return validBluetoothData;
}

// This method is similar to the above method, except that this version DOES BLOCK
// It will keep trying to read until a complete message has been receieved or a timeout is reached
// Returns true if a valid message was received
//bool getBluetoothData()
//{
//  bluetoothData[0] = '\0';
//  if(!bluetoothAvailable())
//    return false;
//  int timeout = 50;
//  int index = 0;
//  bool terminated = false;
//  unsigned long start = millis();
//  while(!terminated && millis() - start < timeout)
//  {
//    while(!bluetoothAvailable() && millis() - start < timeout);
//    bluetoothData[index++] = getBluetoothChar();
//    start = millis();
//    terminated = (bluetoothData[index-1] == '\0');
//  }
//  if(index > 0 && bluetoothData[index-1] != '\0')
//    bluetoothData[index] = '\0';
//  // If it is a heartbeat, respond to it now
//  if(equals(bluetoothData, "?"))
//  {
//    sendBluetoothData("?");
//    bluetoothData[0] = '\0';
//    return false;
//  }
//  robotPrintDebug("Got BT data <"); robotPrintDebug(bluetoothData); robotPrintlnDebug(">");
//  return true;
//}

// Returns the value of bluetoothConnected
// This variable must be set somewhere, probably in processBluetoothData
bool isBluetoothConnected()
{
  return bluetoothConnected;
}

// Read bluetooth data and then process it
void processBluetoothData()
{
  if(!getBluetoothData())
    return;
  // DO SOMETHING WITH bluetoothData HERE
  // If it is a valid message, set bluetoothConnected = true
  bluetoothConnected = true;
}

char* returnBluetoothData(){
  return bluetoothData;
}

bool isBluetoothDataValid()
{
  return validBluetoothData;
}

void robotLoop()
{
  //robotPrintlnDebug();
  processBluetoothData();
}

void robotSetup()
{
  bt.baud(9600);
  //sendBluetoothData("AT+NAME");
  //sendBluetoothData("myRobotBT");
  bluetoothConnected = false;
  validBluetoothData = false;
  bluetoothData[0] = '\0';
}

void sendBluetoothData(const char* data)
{
  robotPrintDebug("Sending BT data <"); robotPrintDebug(data); robotPrintlnDebug(">");
  int index = 0;
  for(; index < length(data); index++)
    {
      sendBluetoothChar(data[index]);
      wait_ms(5);
    }
  if(data[index-1] != '\0')
    sendBluetoothChar('\0');
  robotPrintDebug("Sent BT data <"); robotPrintDebug(data); robotPrintlnDebug(">");
}