#include "mbed.h"
#include "nRF24L01P.h"
#define IWDG_START 0x0000CCCC
#define IWDG_WRITE_ACCESS 0x00005555
#define IWDG_PR_PR_0 7
#define IWDG_RELOAD 512*100
#define IWDG_REFRESH 0xAAAA
Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(D4,D5,D3,D10,D8,D9);    // mosi, miso, sck, csn, ce, irq


int main()
{
//                          
    //              pLATHALTER FÜR ANSHCALTEN ÜBER GPIO
        //
        
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   2

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setAirDataRate(250);
    my_nrf24l01p.setTxAddress(0xE7E7E7E7E1,5);
    my_nrf24l01p.setRxAddress(0xE7E7E7E7E7,5,0);
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setTransmitMode();
    my_nrf24l01p.enable();
    txData[1] = 2;
    txData[0] = 23;
    txDataCnt =1;
    IWDG->KR=IWDG_START;
    IWDG->KR=IWDG_WRITE_ACCESS;
    IWDG->PR=IWDG_PR_PR_0;
    IWDG->RLR=IWDG_RELOAD;
    while(IWDG->SR) {
        wait(0.1);
    }
    my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
    wait(1);
    IWDG->KR=IWDG_REFRESH; /* (6) */
    pc.printf("go to sleep");
    deepsleep();
    while (1) {

        /*
        // If we've received anything over the host serial link...
        if ( pc.readable() ) {

            // ...add it to the transmit buffer
            txData[txDataCnt++] = pc.getc();

            // If the transmit buffer is full
            if ( txDataCnt >= sizeof( txData ) ) {

                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );

                txDataCnt = 0;
            }

            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
           // myled1 = !myled1;
        }

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {

                pc.putc( rxData[i] );
            }

            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            //myled2 = !myled2;
        }
        */
    }
}
