#include "mbed.h"

const int mosfet1_resistence = 100; // Resistence in Ohm

AnalogIn voltage0(A0); // Edit Pin-Port for the battery-voltage measurement
AnalogIn voltage1(A1); // Edit Pin-Port for the throttle-voltage measurement
AnalogIn voltage2(A2); // Edit Pin-Port for the capacitor-voltage measurement
DigitalIn breaksensor(PA_5); //Edit Pin-Port for the breaksensor measurement!
AnalogIn voltage3(A3);   // Pin-Port for voltage before Mosfet1
AnalogIn voltage4(A4); // Pin-Port for voltage after Mosfet2
Timer timer2;            // Timer for Capacity-Measurement

float accu_voltage(){
    
    float meas0;            
    meas0 = voltage0.read(); // read adc value
    return meas0;           // return value
    }
    
float hall_umrechnung(){
    float meas0;
    meas0 = voltage1.read() - 0.27; // read adc and rearange the voltage_value,because its 0.27 when the throttle is off
    
    if(meas0 < 0){          // meas0 isnt allowed to be <0 because its sets the pulsewidht of the pwm
        meas0 = 0;
        }
    
    meas0 = meas0*2;  // creates values between 0 and 1
    
    if(meas0 > 1){      // meas0 isnt allowed to be >1 because its sets the pulsewidth of the pwm 
        meas0 = 1;
        }
    
    return meas0;    // return value
    }
//-------------Code für Bremsenergierückgewinnung---------------    
/*    
float Capacitor_Voltage(){
    
    float meas0;
    meas0 = voltage2.read(); //read adc value
    return meas0; // return value
    }
*/ //-----------------------------------------------------------
int break_value(){
    int break_value;  
    break_value = breaksensor.read(); // read breaksensor value(1/0)
    return break_value; // return value
    }
float battery_charge(){
    Timer timer2;
    float battery_charge,current;
    int time,voltage_before,voltage_after;
    voltage_before = voltage3.read()*12.0; // voltage  in V
    voltage_after  = voltage4.read()*12.0;  // voltage in V
    current = (voltage_before - voltage_after)/(mosfet1_resistence); // current in A
    timer2.start(); // Timer start
    time = timer2.read_ms();
    while(time < 10){  // loop to get 0.01s delay
        ;
        }
    timer2.stop(); 
    timer2.reset();
       
    battery_charge = battery_charge - current*0.01; 
    return battery_charge;
    }  