#include "mbed.h"
#include "DS1820.h"
#include "tsi_sensor.h"

//defino entradas
DS1820 probe(PTD4);
AnalogIn preset(PTC1);
DigitalIn sensor_cooler(PTA12);

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

//general
enum maquina_de_estados_general {inicio1, lazo_abierto, lazo_cerrado};
maquina_de_estados_general maquina_general;
void funcion_general();
int pulsador = 0;

//lazo_cerrado
enum maquina_de_estados_lazo_cerrado {inicio2, detecto_valor_temp, cooler_200rpm, cooler_vel_max, cooler_vel_aumenta_lineal};
maquina_de_estados_lazo_cerrado maquina_lazo_cerrado;
void funcion_lazo_cerrado();
float detecto_temp();
int cambio_a_lazo_cerrado = 0;
float temperatura = 0.0;
float rpm = 0;
float duty = 0;
float valor = 0.0;

//lazo abierto
enum maquina_de_estados_lazo_abierto {inicio3, detecto_valor_pote, vario_vel_cooler};
maquina_de_estados_lazo_abierto maquina_lazo_abierto;
void funcion_lazo_abierto();
int cambio_a_lazo_abierto = 0;

//ticker
Ticker tiempo;
int contador = 0;
int a = 0;


PwmOut salida1(PTB3);//defino el cooler como salida
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);//defino TSI

//defino variables para poder medir las RPM
int cuento_rpm() ;
int rpm_tot = 0;
int rpmm = 0;
int contador2 = 0;

//funcion para saber las RPM 
void funcion_tiempo()
{
    contador2++;
    rpmm = rpm_tot*60;//rpm_tot en 1 segundo, multiplico por 60 para que sea un minuto (RPM)
    rpm_tot = 0;
}
int main()
{
    salida1 = 1.0;//comienza el programa con el cooler encendido
    wait(2);//un wait fuera del while, que no afecta el programa
    tiempo.attach(&funcion_tiempo, 1);

    while(1) {
        //reconozco los flancos del sensor de RPM
        if((sensor_cooler == 1) && (a == 0)) {
            rpm_tot++;
            a = 1;
        }
        else if((sensor_cooler == 0) && (a == 1))
            a = 0;

        funcion_general();
        funcion_lazo_cerrado();
        funcion_lazo_abierto();
    }
}
//funcion que devuelve la temperatura
float detecto_temp()
{
     if(contador2 == 1)
     probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
     printf("   temperatura: %3.1f", probe.temperature());
     contador2 = 0;
     return probe.temperature();
}

//funcion de la máquina de estados general
void funcion_general()
{
    switch(maquina_general) {

        default:
            maquina_general = inicio1;
            break;

        case inicio1:
            //apreto TSI para dar inicio al sistema
            if(tsi.readPercentage() != 0) {
                cambio_a_lazo_cerrado = 1;
                maquina_general = lazo_cerrado;
            }
            break;

        case lazo_cerrado:
            //entrta al if cuando estoy en el modo lazo cerrado
            //y se presiona el TSI
            if(cambio_a_lazo_cerrado == 0) {
                cambio_a_lazo_abierto = 1;
                maquina_general = lazo_abierto;
            }
            
            ///////PARA CAMBIAR DE MODO//////
            if(tsi.readPercentage() >= 0.5) {
                cambio_a_lazo_cerrado = 0;
                maquina_lazo_cerrado = inicio2;
            }
            /////////////////////////////////
            break;

        case lazo_abierto:
            //entrta al if cuando estoy en el modo lazo abierto
            //y se presiona el TSI
            if(cambio_a_lazo_abierto == 0) {
                cambio_a_lazo_cerrado = 1;
                maquina_general = lazo_cerrado;
            }

            ///////PARA CAMBIAR DE MODO//////
            if((tsi.readPercentage() <= 0.4) && (tsi.readPercentage() != 0)) {
                cambio_a_lazo_abierto = 0;
                maquina_lazo_abierto = inicio3;
            }
            /////////////////////////////////
            break;
    }
}
//funcion del modo lazo cerrado
void funcion_lazo_cerrado()
{
    switch (maquina_lazo_cerrado) {

        default:
            maquina_lazo_cerrado = inicio2;
            break;

        case inicio2:
            if (cambio_a_lazo_cerrado == 1) {
                printf("\n\rLAZO CERRADO\r\n");
                maquina_lazo_cerrado = detecto_valor_temp;
            }
            break;

        case detecto_valor_temp:
            temperatura = detecto_temp();
            if(temperatura <= 20) { //cooler 200rpm
                maquina_lazo_cerrado = cooler_200rpm;
            }
            if(temperatura >= 70) { //cooler maximo
                maquina_lazo_cerrado = cooler_vel_max;
            }
            if((temperatura > 20) && (temperatura < 70))//cooler varia 
                maquina_lazo_cerrado = cooler_vel_aumenta_lineal;
            break;

        case cooler_200rpm:
            //el cooler a 200RPM
            salida1.write(0.0222);

            printf(" RPM = %d",rpmm);
            
            maquina_lazo_cerrado = detecto_valor_temp;
            break;

        case cooler_vel_max:
            //cooler a maxima RPM
            salida1 = 1.0;

            printf("RPM = %d",rpmm);

            maquina_lazo_cerrado = detecto_valor_temp;

            break;

        case cooler_vel_aumenta_lineal:
            //cooler aumenta segun la temperatura
            rpm = ((temperatura * 200) / 20);

            duty = ((rpm * 100) / 9000);

            valor = (duty / 10);

            salida1.write(valor);
            
            printf(" RPM: %f ",rpm);

            maquina_lazo_cerrado = detecto_valor_temp;
            break;
    }
}
//modo lazo abierto
void funcion_lazo_abierto()
{
    switch(maquina_lazo_abierto) {

        default:
            maquina_lazo_abierto = inicio3;
            break;

        case inicio3:
            if(cambio_a_lazo_abierto == 1) {
                printf("LAZO_ABIERTO\n");
                maquina_lazo_abierto = detecto_valor_pote;

            }
            break;

        case detecto_valor_pote:
            //si el pote esta por debajo de 0,2 (pasado con el ADC
            //cooler con 200 RPM
            if(preset <= 0.0222) {
                salida1.write(0.222);
                printf(" RPM: %d",rpmm);
            } else {
                maquina_lazo_abierto = vario_vel_cooler;
            }
            break;

        case vario_vel_cooler:

            salida1.write(preset);//vario cooler segun preset

            printf(" RPM: %d",rpmm);

            maquina_lazo_abierto = detecto_valor_pote;

            break;
    }
}