#include "mbed.h"
#include "tsi_sensor.h"
#include "stdlib.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
//defino las salidas
DigitalOut verde(LED_GREEN);
DigitalOut azul(LED_BLUE);
DigitalOut rojo(LED_RED);

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

int PULS_TSI();
int COLORES();

//General
enum MAQUINA_ESTADO_GENERAL {INICIO, MUESTRO_SEC, ESPERO_SEC, APRETO, LOOSER, WIN};
MAQUINA_ESTADO_GENERAL MAQUINA_GENERAL;
void FUNCION_GENERAL();

//Muestro
enum MAQUINA_ESTADO_MUESTRO {INICIO2, ON, OFF};
MAQUINA_ESTADO_MUESTRO MAQUINA_MUESTRO;
void FUNCION_MOSTRAR();
char paso [25];
int nivel_muestro = 0;
int nivel_mostrando = 0;
int variable = 0;

//Apreto
enum MAQUINA_ESTADO_APRETO {INICIO3, ESPERO_PULS, COMPARO_PULS, DELAY, DELAY2};
MAQUINA_ESTADO_APRETO MAQUINA_APRETO;
void FUNCION_APRETO();
int espero_puls = 0;
int estado_prox = 0;

//tiempo
Ticker tiempo;
int contador = 0;
int contador_muestro = 0;
int contador_apreto = 0;
int PULSADOR = 5;
int mostrando = 0;
int apretar = 0;
void funcion_tiempo();

//funcion de los botones para el tsi
int PULS_TSI()
{
    if((tsi.readPercentage() > 0.06) && (tsi.readPercentage() < 0.2))
        PULSADOR = 0;//0 designado para el color rojo
    else if((tsi.readPercentage() > 0.4) && (tsi.readPercentage() < 0.6))
        PULSADOR = 1;//1 designado para el color verde
    else if((tsi.readPercentage() > 0.8) && (tsi.readPercentage() < 0.94))
        PULSADOR = 2;//2 designado para el color azul
    else
        PULSADOR = -1;//-1 designado cuando no se oprime el TSI

    return PULSADOR;//me devuelve lo que aprete
}
//funcion que prende los leds 
void COLORES(int color)
{
    switch(color) {
        case 0://rojo
            rojo = 0;
            verde = 1;
            azul = 1;
            break;
        case 1://verde
            rojo = 1;
            verde = 0;
            azul = 1;
            break;
        case 2://azul
            rojo = 1;
            verde = 1;
            azul = 0;
            break;
    }
}

int main(void)
{
    //defino los leds como apagados
    verde = 1;
    azul = 1;
    rojo = 1;
    tiempo.attach(&funcion_tiempo, 0.1);
    
    while (true) {
        variable++;//variable usada para el srand
        FUNCION_GENERAL();//GENERAL
        FUNCION_MOSTRAR();//MOSTRAR
        FUNCION_APRETO();//APRETAR
    }
}

void funcion_tiempo()
{
    contador++;
    contador_muestro++;
    contador_apreto++;
}

//GENERAL
void FUNCION_GENERAL()
{
    switch (MAQUINA_GENERAL) {

        default:
            MAQUINA_GENERAL = INICIO;
            break;
        case INICIO://igualo todas mis variables a 0 
            mostrando = 0;
            espero_puls = 0;
            nivel_muestro = 0;
            nivel_mostrando = 0;
            contador = 0;
            contador_muestro = 0;
            contador_apreto = 0;
            PULSADOR = 5;
            mostrando = 0;
            apretar = 0;
            if(tsi.readPercentage() != 0) {//oprimo TSI
                contador = 0;
                mostrando = 1;
                MAQUINA_GENERAL = MUESTRO_SEC;
            }
            break;
        case MUESTRO_SEC:
            if(mostrando == 0) {//mostrando va a ser 0 cuando en la funcion de mostrar ya mostro todo
                MAQUINA_GENERAL = ESPERO_SEC;
                apretar = 1;
            }
            break;
        case ESPERO_SEC:
            if(apretar == 0) {
                MAQUINA_GENERAL = MUESTRO_SEC;
                mostrando = 1;
            }
            break;
        case LOOSER://caso cuando perdes
        //prende salida color violeta por 2 segundos luego vuelve a inicio
            azul = 0;
            rojo = 0;
            verde = 1;
            if(contador >= 20) {
                azul = 1;
                rojo = 1;
                verde = 1;
                contador = 0;
                MAQUINA_GENERAL = INICIO;
            }
            break;
        case WIN://caso cuando ganas
        //prende salida color amarillo por 2 segundos luego vuelve a inicio
            contador = 0;
            rojo = 0;
            verde = 0;
            azul = 1;
            if(contador >= 20) {
                azul = 1;
                rojo = 1;
                verde = 1;
                contador = 0;
                MAQUINA_GENERAL = INICIO;
            }
            break;
    }
}
//MOSTRAR
void FUNCION_MOSTRAR()
{
    switch (MAQUINA_MUESTRO) {
        default:
            MAQUINA_MUESTRO = INICIO2;
            break;
        case INICIO2:
            if(mostrando == 1) {
                nivel_mostrando = 0;
                srand(variable);//como variable va a estar siempre variando, srand tomara distintas posiciones
                paso[nivel_muestro++] = (rand() % 3);//genero mi secuencia con numero al azar entre 0 y 2
                //POR QUE NIVEL VOY (nivel muestro)

                if(nivel_muestro == 24) {//si llego a 24 niveles, gano
                    mostrando = 0;
                    MAQUINA_GENERAL = WIN;
                    MAQUINA_MUESTRO = INICIO2;
                }
                contador_muestro = 0;
                MAQUINA_MUESTRO = ON;
            }
            break;
        case ON:
            COLORES(paso[nivel_mostrando]);//prendo los colores de la secuencia 

            //CUAL ESTOY MOSTRANDO AHORA (nivel_mostrando)
            //a medida que se aumentan los niveles se disminuye el tiempo de encendido de los leds
            if (nivel_muestro <= 5) {
                if (contador_muestro >= 10) {
                    contador_muestro = 0;
                    MAQUINA_MUESTRO = OFF;
                }
            }
            if ((nivel_muestro > 5)&&(nivel_muestro <= 10)) {
                if (contador_muestro >= 8) {
                    contador_muestro = 0;
                    MAQUINA_MUESTRO = OFF;
                }
            }
            if ((nivel_muestro > 10)&&(nivel_muestro <= 15)) {
                if (contador_muestro >= 6) {
                    contador_muestro = 0;
                    MAQUINA_MUESTRO = OFF;
                }
            }
            if ((nivel_muestro > 15)&&(nivel_muestro <= 20)) {
                if (contador_muestro >= 10) {
                    contador_muestro = 0;
                    MAQUINA_MUESTRO = OFF;
                }
            }
            if ((nivel_muestro > 20)&&(nivel_muestro <= 24)) {
                if (contador_muestro >= 10) {
                    contador_muestro = 0;
                    MAQUINA_MUESTRO = OFF;
                }
            }
            break;
        case OFF://apago las salidas
            rojo = 1;
            verde = 1;
            azul = 1;
            if(contador_muestro >= 5) {//tiempo de espera entre led y led
                if((nivel_mostrando) == (nivel_muestro - 1)) {//si se mostraron todos los niveles
                    mostrando = 0;//en la maquina general hbailita a pasar al caso de espero_sec
                    MAQUINA_MUESTRO = INICIO2;
                } else {//si quedan niveles por mostrar
                    nivel_mostrando++;//aumento variable para luego mostrar proximo nivel
                    contador_muestro = 0;
                    MAQUINA_MUESTRO = ON;//vuelvo a prender el siguiente nivel
                }
            }
    }
}
//APRETAR
void FUNCION_APRETO()
{
    switch(MAQUINA_APRETO) {
        default:
            MAQUINA_APRETO = INICIO3;
            break;
        case INICIO3:
            if(apretar == 1) {//habilitado por la maquina general cuando entro al case espero_sec
                espero_puls = 0;
                contador_apreto = 0;
                MAQUINA_APRETO = ESPERO_PULS;
            }
            break;
        case ESPERO_PULS:

            if(PULS_TSI() != -1) {//si oprimo el tsi
                if(PULS_TSI() == paso[espero_puls]) {//si lo oprimido es el seleccionado para el color asignado previamente
                    if(espero_puls < (nivel_muestro-1)) {//si no oprimi todos los niveles
                        espero_puls++;//sumo variable para apretar el proximo nivel y comparar
                        contador_apreto = 0;
                        MAQUINA_APRETO = DELAY;//voy al caso en el que se muestran los leds que aprete
                        estado_prox = 1;//en el caso de tener que seguir apretando
                    } else {
                        MAQUINA_APRETO = DELAY;//voy al caso en el que se muestran los leds que aprete
                        estado_prox = 2;//en el caso de no tener que apretar mas
                    }
                } else {// si lo oprimido no es lo seleccionado para el color asignado previamente
                    contador = 0;
                    MAQUINA_GENERAL = LOOSER;//pierdo
                    MAQUINA_APRETO = INICIO3;
                }
            }
            if(contador_apreto >= 30) {//si pasaron 3 segundos y no oprimi nada
                contador = 0;
                contador_apreto = 0;
                MAQUINA_GENERAL = LOOSER;//pierdo
                MAQUINA_APRETO = INICIO3;
            }
            break;
        case DELAY://caso de delay
            COLORES(PULS_TSI());//muestro los leds que oprimo con el TSI
            if(contador_apreto > 2) {//genero un tiempo de 200ms
                MAQUINA_APRETO = DELAY2;//voy al caso donde apago los leds
                contador_apreto = 0;
            }
            break;
        case DELAY2:
        //apago los leds
            rojo = 1;
            azul = 1;
            verde = 1;

            if(estado_prox == 1 && contador_apreto > 2) {//genero otro timepo de 200ms para poder volver a leer el TSI
            //y si tengo que seguir apretando
                MAQUINA_APRETO = ESPERO_PULS;//vuelvo al caso donde oprimo los niveles siguientes
                contador_apreto = 0;
            } else if(estado_prox == 2 && contador_apreto > 2) {//y si no tengo que apretar mas
            //y genero otro timepo de 200ms
                apretar = 0;//hbailito a quer maquina general vuelva a muestro_sec
                MAQUINA_APRETO = INICIO3;
                contador_apreto = 0;
            }
            break;
    }
}