#include "mbed.h"
#include "tsi_sensor.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
Ticker contador;
Ticker titila;

//Enumero los distintos casos de la Maquina de Estados
enum maquina_estado_general {INICIO, CABLE1, CABLE2, CABLE3, CABLE4, WIN, LOOSER};
maquina_estado_general maquina_general;

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

//Defino salidas utilizadas
AnalogIn noise (PTC1);
DigitalIn cable_0 (PTB0);
DigitalIn cable_1 (PTB1);
DigitalIn cable_2 (PTB2);
DigitalIn cable_3 (PTB3);
DigitalOut verde (LED_GREEN);
DigitalOut rojo (LED_RED);
DigitalOut buzzzer (PTC12);
BusOut Unidades (PTE2,PTE3,PTE4,PTE5);
BusOut Decenas (PTB8,PTB9,PTB10,PTB11);

//Creo y defino vectores
int vector_secuencia [4];
int vector_orden_cables [4] = {-1, -1, -1, -1};

//Defino variables
int ccero = 0;
int cuno = 0;
int cdos = 0;
int ctres = 0;
int sumador = 0;
int contadorun = 0;
int contadordec = 0;
int contadortotal = 60;
int mandar = 0;
int titilarun = 0;
int titilardec = 0;
int titilar = 0;
int x = 0;
int z = 0;
int a = 0;

//Prototipo de funciones
void secuencia();
void maquina_general_sec ();
void orden_cables ();
void suma ();
void funcion_tiempo ();
void funcion_titila ();
void buzzer ();
int cablesDesconectados(int n);

int main(void)
{
    //Activo Pull Up interno
    cable_0.mode (PullUp);
    cable_1.mode (PullUp);
    cable_2.mode (PullUp);
    cable_3.mode (PullUp);

    //Salida que mide ruido para la semilla de la funcion rand
    srand (int(noise * 10000));

    secuencia ();
    verde = 1;
    rojo = 1;
    contador.attach (&funcion_tiempo, 1);
    titila.attach (&funcion_titila, 0.5);

    while (true) {
        
        maquina_general_sec ();
        orden_cables ();

    }
}

/*Funcion que crea la secuencia del orden que hay que sacar los cables
y los guarda en un vector evitando que se repita el numero*/
void secuencia ()
{
    vector_secuencia [0] = rand () %4;
    for (int i = 1; i < 4; i++) {
        int randomm = rand () %4;
        int aux = 1;
        for(int j = 0; j < i; j++)
            if(vector_secuencia[j] == randomm)
                aux = 0;
        if(aux)
            vector_secuencia[i] = randomm;
        else
            i--;
    }

}

//Maquina de Estado general para arranque, pasaje de un cable a otro y reinicio
void maquina_general_sec ()
{
    switch (maquina_general) {

        default:
            maquina_general = INICIO;
            break;
//Se arranca apretando el tsi y con los display en 60seg. (TSI tambien para reiniciar)
        case INICIO:
            rojo = 1;
            verde = 1;
            buzzzer = 0;
            if (tsi.readPercentage() != 0) {
                a = 0;
                contadortotal = 60;
                x = 1;
                mandar = 1;
                z = 0;
                maquina_general = CABLE1;
            }
            break;
//Compara el primer cable con la secuencia creada
        case CABLE1:
            if (vector_secuencia [0] == vector_orden_cables [0] && vector_orden_cables [0] != -1) {
                maquina_general = CABLE2;
            }
            if (vector_secuencia [0] != vector_orden_cables [0] && vector_orden_cables [0] != -1) {
                maquina_general = LOOSER;
            }

            break;
//Compara el segundo cable con la secuencia creada
        case CABLE2:
            if (vector_secuencia [1] == vector_orden_cables [1] && vector_orden_cables [1] != -1) {
                maquina_general = CABLE3;
            }
            if (vector_secuencia [1] != vector_orden_cables [1] && vector_orden_cables [1] != -1) {
                maquina_general = LOOSER;
            }

            break;
//Compara el tercer cable con la secuencia creada
        case CABLE3:
            if (vector_secuencia [2] == vector_orden_cables [2] && vector_orden_cables [2] != -1) {
                maquina_general = CABLE4;
            }
            if (vector_secuencia [2] != vector_orden_cables [2] && vector_orden_cables [2] != -1) {
                maquina_general = LOOSER;
            }
            break;
//Compara el cuarto cable con la secuencia creada
        case CABLE4:
            if (vector_secuencia [3] == vector_orden_cables [3] && vector_orden_cables [3] != -1) {
                maquina_general = WIN;
            }
            if (vector_secuencia [3] != vector_orden_cables [3] && vector_orden_cables [3] != -1) {
                maquina_general = LOOSER;
            }
            break;
//Si el orden es correcto titilan los display y led verde
        case WIN:
            z = 1;
            rojo=1;
            if (titilar %2 == 0) {
                Unidades = titilarun;
                Decenas = titilardec;
                buzzzer = 1;
                verde = 0;
            } else if(titilar %2 != 0) {
                Unidades = 15;
                Decenas = 15;
                buzzzer = 0;
                verde = 1;
            }

            if (tsi.readPercentage() != 0) {
                maquina_general = INICIO;
                for(int k = 0; k < 4; k++)
                    vector_orden_cables[k] = -1;
                secuencia();

            }

            break;
//Si el orden es incorrecto titilan los display y led rojo
        case LOOSER:
            z = 1;
            if(tsi.readPercentage() == 0) {
                if (titilar %2 == 0) {
                    Unidades = titilarun;
                    Decenas = titilardec;
                    buzzzer = 1;
                    rojo = 0;
                } else if(titilar %2 != 0) {
                    Unidades = 15;
                    Decenas = 15;
                    buzzzer = 0;
                    rojo = 1;
                }
            }
            if (tsi.readPercentage() != 0) {
                maquina_general = INICIO;
                for(int k = 0; k < 4; k++)
                    vector_orden_cables[k] = -1;
                secuencia();
            }
            break;

    }
}
//Funcion que guarda el orden de los cables que se sacan
void orden_cables ()
{

    if (cable_0 != 0 && cablesDesconectados(0) == 0) {
        ccero = 0;
        vector_orden_cables [a] = ccero;
        a++;
        printf ("vector orden cables [%d] = 0", &a);

    }
    if (cable_1 != 0 && cablesDesconectados(1) == 0) {
        cuno = 1;
        vector_orden_cables [a] = cuno;
        a++;
        printf ("vector orden cables [%d] = 1", &a);

    }
    if (cable_2 != 0 && cablesDesconectados(2) == 0) {
        cdos = 2;
        vector_orden_cables [a] = cdos;
        a++;
        printf ("vector orden cables [%d] = 2", &a);
    }
    if (cable_3 != 0 && cablesDesconectados(3) == 0) {
        ctres = 3;
        vector_orden_cables [a] = ctres;
        a++;
        printf ("vector orden cables [%d] = 3", &a);
    }
}
//Funcion que interpreta la desconexion de los cables
int cablesDesconectados(int n)
{

    for(int j = 0; j < 4; j++) {
        if(vector_orden_cables[j] == n)
            return 1;
    }
    return 0;
}
//Funcion de cuenta regresiva en los display
void funcion_tiempo()
{

    if(contadortotal == 0)
        maquina_general = LOOSER;

    if(!z && x && contadortotal > 0)
        contadortotal--;

    Unidades = contadortotal % 10;
    titilarun = Unidades;
    Decenas = contadortotal / 10;
    titilardec = Decenas;


    printf("%d %d %d %d || %d %d %d %d\n\r", vector_orden_cables[0], vector_orden_cables[1], vector_orden_cables[2], vector_orden_cables[3], vector_secuencia[0], vector_secuencia[1], vector_secuencia[2], vector_secuencia[3]);

}

void funcion_titila ()
{
    titilar++;
}
