// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"
#include "rtos.h"

#include "mbed/logging.h"

#include "RobotArmCfg.h"
#include "ControllerIo.h"

extern void PrepareController();
extern void RunController();
extern bool StartIothubThread();


int main()
{
    mbed_log_init();

    printf("**********************\r\n");
    printf("RobotArmDemo start\r\n");
    printf("**********************\r\n");

    ShowLedGreen();
    
    ReadConfigValues();
    
    // prepare the motion sequences
    PrepareController();
    
    // start IotHub connection
    StartIothubThread();
    
    // time delay is to allow the position encoders to come online after initial power supply event ~ 5 secs
    Thread::wait(5000);
    
    printf("Initialization done. Ready to run. \r\n");

    // try running this thread at a higher priority
    osThreadId maintid = osThreadGetId();
    osThreadSetPriority(maintid, osPriorityHigh);
    
    RunController(); 
}
