// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __MEASUREBUF_H__
#define __MEASUREBUF_H__

#include "mbed.h"
#include "SafeCircBuf.h"
#include "RobotArmCfg.h"


#define MeasureBufSize  8


class MeasureGroup
{
public:
    MeasureGroup() {};
    
    MeasureGroup& operator=(const MeasureGroup& rhs);
    
    void SetMeasure(int numParts, float vals[]);
    
    int NumVals;
    
    float MeasVals[NUMJOINTS];
};

class MeasureSnapshot
{
public:
    MeasureSnapshot() {};
    
    MeasureGroup Temps;
    
    MeasureGroup Volts;
    
    MeasureGroup Loads;
    
    MeasureGroup Positions;
    
    time_t Created;
    
    int CreatedMs;
};

extern SafeCircBuf<MeasureSnapshot, MeasureBufSize, uint32_t> MeasureBuf;

#endif