// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __IOTHUB_SERIAL_H__
#define __IOTHUB_SERIAL_H__

#include "mbed.h"
#include "MeasureBuf.h"
#include "Alert.h"

class IothubSerial
{
public:
    IothubSerial();
    
    int MeasureBufToString(char* buf, int bufsize);

    int AlertBufToString(char* buf, int bufsize);
    
private:
    int MeasureGroupToString(const char* name, MeasureGroup& mg, char* buf, int bufsize);
    
    int MeasureSnapshotToString(MeasureSnapshot& msnap, char* buf, int bufsize);
    
    MeasureSnapshot _pending;
    
    bool _hasPending;
    
    Alert _pendAlert;

};

#endif
