// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"
#include "rtos.h"

#include "ActionBuf.h"


ActionSequence::ActionSequence()
{
};

ActionSequence::ActionSequence(SequenceAction aType)
{
    ActionType = aType;
    Param = 0;
    NumParts = 0;
};

ActionSequence::ActionSequence(SequenceAction aType, int parts, const float vals[], int param)
{
    ActionType = aType;

    if (parts > NUMJOINTS) parts = NUMJOINTS;
    
    if (vals != NULL)
    {
        for (int i = 0; i < parts; i++)
            GoalVals[i] = vals[i];
    }
    NumParts = parts;
    
    Param = param;
}

void ActionSequence::SetGoal(int parts, const float vals[])
{
    if (parts > NUMJOINTS) parts = NUMJOINTS;
    
    if (vals != NULL)
    {
        for (int i = 0; i < parts; i++)
            GoalVals[i] = vals[i];
    }
    NumParts = parts;
}

void ActionSequence::SetParam(int param)
{
    Param = param;
}
    
void ActionSequence::SetAction(SequenceAction aType)
{
    ActionType = aType;
}


