// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __ROBOT_NODE_H__
#define __ROBOT_NODE_H__

enum NodeMeasure
{
    NM_Temperature      = 0x1,
    NM_Voltage          = 0x2,
    NM_Degrees          = 0x3,
    NM_Load             = 0x4
};

enum NodeAction
{
    NA_Ping             = 0x1,
    NA_Init             = 0x2,
    NA_Rotate           = 0x3,
    NA_ClearError       = 0x4
};

enum NodePartType
{
    NT_AX12             = 0x1,
    NT_Emul             = 0x7f
};


class RobotNode
{
public:
    virtual bool HasMeasure(int measureId) = 0;
    
    virtual float GetMeasure(int measureId) = 0;
    
    virtual void ClearMeasureCache() = 0;
    
    virtual bool HasAction(int actionId) = 0;
    
    virtual bool DoAction(int actionId, float actionValue) = 0;
    
    virtual int GetLastError() = 0;
    
    virtual bool HasError() = 0;
    
    virtual NodePartType GetNodeType() = 0;
};

#endif
