// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __ROBOT_ARM_CFG_H__
#define __ROBOT_ARM_CFG_H__

#include "RobotNode.h"

// define number of joints for this arm
static const int NUMJOINTS  = 5;

// used to configure each joint
typedef struct _NodeCfg
{
    NodePartType    JointType;
    int             JointId;
} NodeCfg;

// specify joints in arm
//static NodeCfg ArmJoints[NUMJOINTS] = {
//    { NT_AX12, 2 },
//    { NT_AX12, 3 },
//    { NT_AX12, 4 },
//    { NT_AX12, 6 },
//    { NT_AX12, 1 }
//};

// specify joints in arm
// array filled in from configuration file
extern NodeCfg ArmJoints[NUMJOINTS];

extern char* connectionString;

extern bool ReadConfigValues();

#endif