// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __ALERT_H__

#include "mbed.h"
#include "SafeCircBuf.h"

#define AlertBufSize  8
#define AlertMsgMaxLen  120
#define AlertTypeMaxLen  16
#define MeasureNameMaxLen  16


class Alert
{
public:
    Alert() {};
    
    void SetAlert(time_t created, int createdMs, char* msg, char* atype);
    
    void SetPositionAlert(time_t created, int createdMs, int partIx, float diff);
    
    void SetLoadAlert(time_t created, int createdMs, int partIx, float val);
    
    void SetHardwareAlert(time_t created, int createdMs, int partIx, int code);
    
    void SetTemperatureAlert(time_t created, int createdMs, int partIx, float temp);
    
    void SetVoltageAlert(time_t created, int createdMs, int partIx, float val);
    
    char AlertType[AlertTypeMaxLen];
    
    char Msg[AlertMsgMaxLen];
    
    int Index;
    
    char MeasureName[MeasureNameMaxLen];
    
    float Value;
    
    time_t Created;
    
    int CreatedMs;
};

extern SafeCircBuf<Alert, AlertBufSize, uint32_t> AlertBuf;

#endif
