// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __NODE_AX12_H__
#define __NODE_AX12_H__

#include "RobotNode.h"
#include "AX12.h"


class NodeAX12 : public RobotNode
{
public:
    NodeAX12(DynamixelBus* pbus, ServoId ID);
    
    virtual bool HasMeasure(int measureId);
    
    virtual float GetMeasure(int measureId);
    
    virtual void ClearMeasureCache();
    
    virtual bool HasAction(int actionId);
    
    virtual bool DoAction(int actionId, float actionValue);
    
    virtual int GetLastError();
    
    virtual bool HasError();
    
    virtual NodePartType GetNodeType();
    
private:
    AX12 _Servo;
};

#endif
