// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"

#include "MeasureBuf.h"


SafeCircBuf<MeasureSnapshot, MeasureBufSize, uint32_t> MeasureBuf;

void MeasureGroup::SetMeasure(int numParts, float vals[])
{
    NumVals = NUMJOINTS < numParts ? NUMJOINTS : numParts;
    
    for (int ix = 0; ix < NumVals; ix++)
    {
        MeasVals[ix] = vals[ix];
    }
}

MeasureGroup& MeasureGroup::operator=(const MeasureGroup& rhs)
{
    NumVals = rhs.NumVals;
    for (int ix = 0; ix < NUMJOINTS; ix++)
    {
        MeasVals[ix] = rhs.MeasVals[ix];
    }
    return *this;
}

