// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"
#include "rtos.h"

DigitalOut greenLed(LED_GREEN);
DigitalOut redLed(LED_RED);
DigitalOut blueLed(LED_BLUE);

DigitalOut buzzer(D2, 1);


int BuzzStopMs = 0;

void ShowLedColor(int col)
{
    greenLed = 1;
    redLed = 1;
    blueLed = 1;
    
    if (col == 1)
        greenLed = 0;
    else if (col == 2)
        redLed = 0;
    else if (col == 3)
        blueLed = 0;
}

void ShowLedGreen()
{
    ShowLedColor(1);
}

void ShowLedRed()
{
    ShowLedColor(2);
}

void ShowLedBlue()
{
    ShowLedColor(3);
}

void BuzzerStart()
{
    buzzer = 0;
}

void BuzzerStop()
{
    buzzer = 1;
}

void BuzzerStartMs(int nowMs, int durationMs)
{
    BuzzStopMs = nowMs + durationMs;
    BuzzerStart();
}

void BuzzerPoll(int nowMs)
{
    if (BuzzStopMs != 0)
    {
        if (nowMs >= BuzzStopMs)
        {
            BuzzStopMs = 0;
            BuzzerStop();
        }
    }
}
