// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"
#include "crt_abstractions.h"

#include "Alert.h"



SafeCircBuf<Alert, AlertBufSize, uint32_t> AlertBuf;

void Alert::SetAlert(time_t created, int createdMs, char* msg, char* atype)
{
    Created = created;
    CreatedMs = createdMs;
    
    if (strlen(atype) >= AlertTypeMaxLen)
    {
        strncpy(AlertType, atype, AlertTypeMaxLen);
        AlertType[AlertTypeMaxLen - 1] = 0;
    }
    else
    {
        strcpy(AlertType, atype);
    }
    if (strlen(msg) >= AlertMsgMaxLen)
    {
        strncpy(Msg, msg, AlertMsgMaxLen);
        Msg[AlertMsgMaxLen - 1] = 0;
    }
    else
    {
        strcpy(Msg, msg);
    }
}


void Alert::SetPositionAlert(time_t created, int createdMs, int partIx, float diff)
{
    char* msg = "Arm joint failed to move to desired position. Joint %d is off by %f";
    int slen = sprintf_s(Msg, AlertMsgMaxLen, msg, partIx, diff);

    Created = created;
    CreatedMs = createdMs;
    strcpy(MeasureName, "rot");
    Index = partIx;
    Value = diff;
    
    strcpy(AlertType, "Position");
}

void Alert::SetLoadAlert(time_t created, int createdMs, int partIx, float val)
{
    char* msg = "Arm joint reported a high load. Joint %d, load %f";
    int slen = sprintf_s(Msg, AlertMsgMaxLen, msg, partIx, val);

    Created = created;
    CreatedMs = createdMs;
    strcpy(MeasureName, "load");
    Index = partIx;
    Value = val;
    
    strcpy(AlertType, "Load");
}

void Alert::SetHardwareAlert(time_t created, int createdMs, int partIx, int code)
{
    char* msg = "Arm joint reported an error. Joint %d error code %d";
    int slen = sprintf_s(Msg, AlertMsgMaxLen, msg, partIx, code);

    Created = created;
    CreatedMs = createdMs;
    strcpy(MeasureName, "error");
    Index = partIx;
    Value = (float)code;
    
    strcpy(AlertType, "Hardware");
}

void Alert::SetTemperatureAlert(time_t created, int createdMs, int partIx, float temp)
{
    char* msg = "Arm joint reported a high temperature. Joint %d temperature %f";
    int slen = sprintf_s(Msg, AlertMsgMaxLen, msg, partIx, temp);

    Created = created;
    CreatedMs = createdMs;
    strcpy(MeasureName, "temp");
    Index = partIx;
    Value = temp;
    
    strcpy(AlertType, "Temperature");
}

void Alert::SetVoltageAlert(time_t created, int createdMs, int partIx, float val)
{
    char* msg = "Arm joint reported an unexpected voltge. Joint %d volt %f";
    int slen = sprintf_s(Msg, AlertMsgMaxLen, msg, partIx, val);

    Created = created;
    CreatedMs = createdMs;
    strcpy(MeasureName, "volt");
    Index = partIx;
    Value = val;
    
    strcpy(AlertType, "Voltage");
}
