// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __ACTIONBUF_H__
#define __ACTIONBUF_H__

#include "mbed.h"
#include "SafeCircBuf.h"
#include "RobotArmCfg.h"


enum SequenceAction
{
    SA_SetGoal          = 0x1,
    SA_Delay            = 0x2,
    SA_LoopBegin        = 0x3,
    SA_LoopEnd          = 0x4
};

class ActionSequence
{
public:
    ActionSequence();
    
    ActionSequence(SequenceAction aType);
    
 
    ActionSequence(SequenceAction aType, int parts, const float vals[], int param);
    
    void SetGoal(int parts, const float vals[]);
    
    void SetParam(int param);
    
    void SetAction(SequenceAction aType);
    
    SequenceAction ActionType;
    
    float GoalVals[NUMJOINTS];
    
    int NumParts;
    
    int Param;
    
};


#endif