// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef __NODE_Emul_H__
#define __NODE_Emul_H__

#include "RobotNode.h"



class NodeEmul : public RobotNode
{
public:
    NodeEmul(int id);
    
    virtual bool HasMeasure(int measureId);
    
    virtual float GetMeasure(int measureId);
    
    virtual void ClearMeasureCache();
    
    virtual bool HasAction(int actionId);
    
    virtual bool DoAction(int actionId, float actionValue);
    
    virtual int GetLastError();
    
    virtual bool HasError();
    
    virtual NodePartType GetNodeType();
    
private:
    
    // last read temperature
    int _LastTemperature;
    
    // last read position
    float _LastPosition;
    
    // last read voltage
    float _LastVoltage;
    
    // last read load
    float _LastLoad;
};

#endif
