// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"
#include "NodeEmul.h"
#include "threadapi.h"

// emulated device that does nothing

NodeEmul::NodeEmul(int id)
{
    _LastPosition= 20.0f + id;
    _LastTemperature = 30 + id;
    _LastVoltage = 12 + ((float)id * 0.1f);
    _LastLoad = 9 + id;
}


bool NodeEmul::HasMeasure(int measureId)
{
    switch (measureId)
    {
        case NM_Temperature:
            return true;
            
        case NM_Degrees:
            return true;
        
        case NM_Voltage:
            return true;
            
        case NM_Load:
            return true;

        default:
            return false;
    }
}

void NodeEmul::ClearMeasureCache()
{

}

float NodeEmul::GetMeasure(int measureId)
{
    switch (measureId)
    {
        case NM_Temperature:
            return (float)_LastTemperature;
            
        case NM_Degrees:
            return _LastPosition;
        
        case NM_Voltage:
            return _LastVoltage;
            
        case NM_Load:
            return _LastLoad;

        default:
            return 0.0f;
    }
}

bool NodeEmul::HasAction(int actionId)
{
    switch (actionId)
    {
        case NA_Ping:
            return true;
            
        case NA_Init:
            return true;
            
        case NA_Rotate:
            return true;

        case NA_ClearError:
            return true;
            
        default:
            return false;
    }
}


bool NodeEmul::DoAction(int actionId, float actionValue)
{
    switch (actionId)
    {
        case NA_Ping:
            return true;
            
        case NA_Init:
            return true;

        case NA_Rotate:
            _LastPosition = actionValue;
            return true;

        case NA_ClearError:
            return true;

        default:
            return false;
    }
}

NodePartType NodeEmul::GetNodeType()
{
    return NT_Emul;
}

int NodeEmul::GetLastError()
{
    return 0;
}

bool NodeEmul::HasError()
{
    return false;
}
