// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef IOTHUB_ROBOTARM_H
#define IOTHUB_ROBOTARM_H

#include "iothub_mod_client.h"

#include "IothubSerial.h"

class IothubRobotArm
{
public:
    IothubRobotArm();
    
    bool Init();
    
    void Terminate();
    
    void SendMessage(IOTHUB_CLIENT_HANDLE iotHubClient, void* userContextCallback);

private:

    IothubSerial _msgSerialize;
};

extern bool StartIothubThread();

extern void EndIothubThread();

#endif /* IOTHUB_ROBOTARM_H */
