// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"
#include "SDFileSystem.h"
#include "ConfigFile.h"

#include "RobotArmCfg.h"

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); //MOSI, MISO, SCLK, SSEL

ConfigFile cfg;

// connection string filled in from configuration file
// if not using input.cfg configuration file specify connection string here
//    String containing IoT hub Hostname, Device Id & Device Key in the format:
//      "HostName=<host_name>;DeviceId=<device_id>;SharedAccessKey=<device_key>"
char* connectionString = "[device connection string]";

// specify joints in arm
// if not using input.cfg configuration file specify joints here
//static NodeCfg ArmJoints[NUMJOINTS] = {
//    { NT_AX12, 2 },
//    { NT_AX12, 3 },
//    { NT_AX12, 4 },
//    { NT_AX12, 6 },
//    { NT_AX12, 1 }
//};

// joints array filled in from configuration file
NodeCfg ArmJoints[NUMJOINTS];

// read config values from file input.cfg on SD card
// example format of file is
// JointType_0=AX12
// JointType_1=AX12
// JointType_2=AX12
// JointType_3=AX12
// JointType_4=AX12
// JointId_0=2
// JointId_1=3
// JointId_2=4
// JointId_3=6
// JointId_4=1
// IoTConnection=HostName=[device connection string]
//
bool ReadConfigValues()
{
    char value[BUFSIZ];
    bool rc = true;
    
    printf("Reading config\r\n");
    
    /* Read a configuration file from a mbed. */
    if (!cfg.read("/sd/input.cfg")) {
        // sometimes fails first time. Try again
        if (!cfg.read("/sd/input.cfg")) {        
            printf("Failure to read a configuration file.\r\n");
            rc = false;
        }
    }
 
    /* Get configuration values.  */
    if (cfg.getValue("IoTConnection", &value[0], sizeof(value))) {
        int len = strlen(value) + 1;
        connectionString = (char*)malloc(len);
        strcpy(connectionString, value);
    }
    else
    {
        printf("Failure to read a configuration file value IoTConnection.\r\n");
        rc = false;
    }
    
    for (int ix = 0; ix < NUMJOINTS; ix++)
    {
        char key[20];
        
        sprintf(key, "JointType_%d", ix);
        if (cfg.getValue(key, &value[0], sizeof(value))) {
            ArmJoints[ix].JointType = NT_AX12;
        }
        else
        {
            printf("Failure to read a configuration file value %s.\r\n", key);
            rc = false;
        }
        sprintf(key, "JointId_%d", ix);
        if (cfg.getValue(key, &value[0], sizeof(value))) {
            ArmJoints[ix].JointId = atoi(value);
        }
        else
        {
            printf("Failure to read a configuration file value %s.\r\n", key);
            rc = false;
        }
    }
    
    return rc;
}
