#include "mbed.h"
#include "i2cslave.h"
#include "define.h"

char Registar[128] = {};

void check();

int main()
{
    NVIC_SetPriority(TIMER_16_0_IRQn, 20);
    NVIC_SetPriority(TIMER_16_1_IRQn, 20);
    NVIC_SetPriority(TIMER_32_0_IRQn, 20);
    NVIC_SetPriority(TIMER_32_1_IRQn, 20);
    NVIC_SetPriority(I2C_IRQn, 10);
    Ticker tic;
    tic.attach(check, 0.1);
    BusIn pins(dp1, dp6, dp9, dp14, dp17, dp24, dp18, dp2);
    i2cslave myi2c(dp5, dp27, Registar);
    myi2c.address(SE2_addr);
    myi2c.frequency(1000000);
    while(1)
    {
        Registar[0] = pins.read();
    }
}

void check()
{
    Registar[check_reg]++;
    if(Registar[check_reg] > 2)
    {
        NVIC_SystemReset();
    }
}
