#include "mbed.h"
#include "QEI.h"
#include "i2cslave.h"
#include "define.h"

union UNION
{
    int i;
    char c[6];
};

UNION obj;

DigitalOut led(dp28);
void Func()
{
    obj.c[5]++;
    //printf(" %d", obj.c[5]);
    if(obj.c[5] > 2)
    {
        //obj.c[4] = 1;
        NVIC_SystemReset();
    }
}


QEI rorikon(dp1, dp2, NC, 50, QEI::X4_ENCODING);
BusOut leds(dp26, dp24);
Serial slave(dp16, dp15);

int main()
{
    Ticker t;
    t.attach(Func, 0.1);
    i2cslave i2c(dp5, dp27, obj.c);
    i2c.frequency(1000000);
    /*change address every micon***********/
    i2c.address(RE1_addr);
    /**************************************/
    double data = 0;
    
    NVIC_SetPriority(TIMER_16_0_IRQn, 5);
    NVIC_SetPriority(TIMER_16_1_IRQn, 5);
    NVIC_SetPriority(TIMER_32_0_IRQn, 5);
    NVIC_SetPriority(TIMER_32_1_IRQn, 5);
    NVIC_SetPriority(EINT3_IRQn, 20);
    NVIC_SetPriority(EINT2_IRQn, 20);
    NVIC_SetPriority(EINT1_IRQn, 20);
    NVIC_SetPriority(EINT0_IRQn, 20);
    NVIC_SetPriority(I2C_IRQn, 10);
    
    obj.c[4] = 1;
    led = 0;

    while(1)
    {
        data = rorikon.getSumangle();
        if(data < 0.000)
        {
            obj.i = (int)(data*10)*(-1);
            obj.c[4] = 0;
            leds = 3;
        }
        else
        {
            obj.i = (int)(data*10);
            obj.c[4] = 2;
            leds = 0;
        }
    }
}