#include "mbed.h"
#include "i2cslave.h"
#include "define.h"

char Registar[128]= {};
void check();

int main()
{
    BusOut motor1(dp4, dp9, dp13, dp14);
    BusOut motor2(dp25, dp24, dp18, dp17);
    PwmOut pwm1(dp2);
    PwmOut pwm2(dp1);
    motor1 = 0;
    motor2 = 0;
    NVIC_SetPriority(TIMER_16_0_IRQn, 20);
    NVIC_SetPriority(TIMER_16_1_IRQn, 20);
    NVIC_SetPriority(TIMER_32_0_IRQn, 20);
    NVIC_SetPriority(TIMER_32_1_IRQn, 20);
    NVIC_SetPriority(I2C_IRQn, 10);
    i2cslave i2c(dp5, dp27, Registar);
    /*change address every micon***********/
    i2c.address(MD10_addr);
    /**************************************/
    i2c.frequency(1000000);
    Ticker tic;
    tic.attach(check, 0.1);
    char prev_motor1_state = 0;
    char prev_motor2_state = 0;
    while(1)
    {
        pwm1 = (float)(Registar[motor1_pwm]) / 255;
        pwm2 = (float)(Registar[motor2_pwm]) / 255;
        if(Registar[motor1_state] != prev_motor1_state)
        {
            motor1 = 0;
            wait_ms(5);
        }
        if(Registar[motor2_state] != prev_motor2_state)
        {
            motor2 = 0;
            wait_ms(1);
        }
        motor1 = Registar[motor1_state];
        motor2 = Registar[motor2_state];
        prev_motor1_state = Registar[motor1_state];
        prev_motor2_state = Registar[motor2_state];
        wait_ms(40);
    }
}

void check()
{
    Registar[check_reg]++;
    if(Registar[check_reg] > 2)
    {
        NVIC_SystemReset();
    }
}
