#ifndef __INCLUDED_EC_H_
#define __INCLUDED_EC_H_

#ifndef M_pi
#define M_pi 3.141592
#endif
/**@class Ec
@brief increment型encoder用class.
Z相(1周につき1回立ち上がる)の機能あり.
普通に使う分には不必要な機能ですが、回転回数が欲しい場合や、回転が非常に早い物の回転速度が欲しい場合などで
A,B相での処理だとマイコンが追いつかない場合などに使ってください
*/
class Ec
{
protected:
    int S;  //A相B相のパターン（1~4）
    bool stateA,stateB; //A・B相の状態
    int count;  //カウント数 分解能分で一周
    int pre_count;  //一つ前のカウント
    double precount;    //4倍精度カウント
    int solution;   //分解能
    double dt;  //角速度の計算間隔
    double distance_mm_;//距離[mm]
    double diameter_mm_;//測定輪半径
    double count_to_distance_mm_;//カウントを距離に変換する係数
    double gear_rate_;//ギア比(エンコーダタイムプーリー/測定輪タイムプーリー)
    int is_diameter_set;//diameterがセットされていたら1
    //z相用
    bool first;
    int rev;
    double now_time,old_time;
    double RPM,RPM_old;
    int RPM_th;

    InterruptIn signalA_;
    InterruptIn signalB_;
    InterruptIn signalZ_;

    void upA();
    void downA();
    void upB();
    void downB();
    void upZ();
    void downZ();
    void setCountToDistance_mm();//countからdistanceに変換する係数を計算する。
public:
    double omega;   //角速度
    /** コンストラクタの定義
     *
     *  ***Z相の機能を追加したことで引数が増えました!!!!***
     *
     *  main関数の前に必ず一度宣言する
     *
     *  使うエンコーダの数だけ設定する必要がある
     *
     *  @param signalA エンコーダA相のピン名
     *  @param signalB エンコーダB相のピン名
     *  @param signalZ エンコーダZ相のピン名
     *  @param s エンコーダの分解能(省略可)
     *  @param t 角速度計算の間隔(省略可)
     */
    /** @section CAUTION
     *  今まで以下のように定義していたものは
     *  @code
     *  #include "mbed.h"
     *  #include "EC.h"
     *
     *  Ec Ec1(PA_0,PA_1,1024,0.05);
     *  @endcode
     *  次のようにZ相の引数の部分に、NCと入れれば今までの様に使える
     *  @code
     *  #include "mbed.h"
     *  #include "EC.h"
     *
     *  Ec Ec1(PA_0,PA_1,NC,1024,0.05);
     *  @endcode
     */
    Ec(PinName signalA,PinName signalB,PinName signalZ,int s,double t);

    ///countの値を返す関数(int型)
    int getCount();

    /** omega(角速度 rad/s)の値を計算する関数
    * @section CAUTION
     *  CalOmega関数は、一定時間ごと（dtごと）に計算される必要があるので、main関数内でタイマー割り込みを設定する必要がある。
     *  @code
     *  #include "mbed.h"
     *  #include "EC.h"        //ライブラリをインクルード
     *
     *  Ec Ec1(PA_0,PA_1,NC,1024,0.05); //分解能1024、計算間隔0.05秒に設定、Z相は使わない
     *  Ticker ticker;
     *  DigitalIn button(USER_BUTTON);
     *  Serial pc(USBTX,USBRX);
     *
     *  void calOmega(){
     *      Ec1.CalOmega();
     *  }
     *
     *  int main(){
     *      ticker.attach(&calOmega,0.05); //0.05秒間隔で角速度を計算
     *     while(1){
     *          pc.printf(" count1=%d ",Ec1.getCount());
     *          pc.printf(" omega1=%f\r\n ",Ec1.getOmega());
     *          if(pc.readable()) {
     *              char sel=pc.getc();
     *              if(sel=='r') Ec1.reset(); //rを押したらリセット
     *          }
     *      }
     *  }
     * @endcode
     */
    void CalOmega();

    ///omega(角速度 rad/s)の値を返す関数(double型)
    double getOmega();
    ///四倍精度のcountの値を返す関数(double型)
    double getPreCount();
    ///エンコーダを初期状態に戻す関数 countやomegaの値を0にする
    virtual void reset();
    ///角速度計算の間隔dtを決めることができる（デフォルトは0.05秒）
    void setTime(double t);
    ///(Z相を使用する場合)回転回数を返す関数(int型)
    int getRev();

    ///(Z相を使用する場合)回転速度(rpm)の値を返す関数(double型)
    /** @section SAMPLE
     *  z相を使う場合のプログラムの例
     *  @code
     *  #include "mbed.h"
     *  #include "EC.h"        //ライブラリをインクルード
     *
     *  Ec Ec1(NC,NC,PA_0,1024,0.05); //A相B相が不必要な場合も、このようにNCと入れればよい
     *  DigitalIn button(USER_BUTTON);
     *  Serial pc(USBTX,USBRX);
     *
     *  int main(){
     *     while(1){
     *          pc.printf(" rev1=%d ",Ec1.getRev());
     *          pc.printf(" rpm1=%f\r\n ",Ec1.getRPM());
     *          if(!button) Ec1.reset();     //USERボタンを押したらリセット
     *      }
     *  }
     * @endcode
     */
    double getRPM();
    void changeRPM_th(int th);

    /** @caution 先にsetDiameter_mmをしないと正しい値とならない
    @return 現在距離.
    @code
#include <mbed.h>
#include "EC.h"
Ec ec(PB_5, PB_4, NC, 500, 0.5);
int main()
{
    ec.setDiameter_mm(48);
    while(1) {
        printf("%f\r\n", ec.getDistance_mm());
        wait(0.1);
    }
}
@endcode
    */
    double getDistance_mm();

    /** @param diameter_mm 測定輪半径
    */
    void setDiameter_mm(double diameter_mm);
    /** @param gear比(エンコーダタイムプーリー/測定輪タイムプーリー)
    */
    void setGearRate(double gear_rate);
    static double deftime;//角速度計算の間隔
    static int defsolution;//エンコーダの分解能のデフォルト値
    Timer timer;
};


#endif