#include"LEDCUBE_RGB_888.h"
#include <math.h>

SPIShiftReg SReg2(D11,D13,D10);      //data, dclk, rck
SPIShiftReg SReg(PC_12,PC_10,D7);      //data, dclk, rck
AnalogIn seed(A5);

extern char VRam[64][3] = {0,0,0,};

char checkColor(char dat, int C, int i){
    if(C == i)return dat;
    else return 0;
}
void IniVRam(char dat){
    for(int i = 0; i < 64; i++){
        for(int c = 0; c < 3; c++){
            VRam[i][c] = dat;
        }
    }
}
//VRamFunctions---------------------------------------
int multiple(int i){
    if(i == 0)return 0;
    int hoge = 1;
    while(i % hoge){
        hoge++;
    }
    return hoge;
}
uint32_t GetV(uint8_t R, int8_t G, uint8_t B){
    return (R << 16) | (G << 8) | B;
}
COL GetColor(bool R, bool G, bool B){
    return (R << 2) | (G << 1) | B;
}
void PutPixel(int x, int y, int z, uint8_t Color){
    if(x <= -1 || x >= 8)return;
    if(y <= -1 || y >= 8)return;
    if(z <= -1 || z >= 8)return;
    for(int i = 0; i <3; i++){ 
        if(Color & (1<<i))VRam[(x * 8) + y][i] |= 1 << z;
        else VRam[(x * 8) + y][i] &= ~(1 << z);
    }
}
void DrawLine(int x1, int y1, int z1, int x2, int y2, int z2, COL Color){
    
}
void DrawBox(int x1, int y1, int z1, int x2, int y2, int z2, COL Color, bool f){
    if(f)
        for(int x = x1; x < x1+x2; x++){
            for(int y = y1; y < y1+y2; y++){
                for(int z = z1; z < z1+z2; z++){
                    PutPixel(x, y, z, Color);
                }
            }
        }
    else
        volatile int xx = 0, yy = 0, zz = 0;
        for(int x = x1, xx = 0; x < x1+x2; x++, xx++){
            for(int y = y1, yy = 0; y < y1+y2; y++, yy++){
                for(int z = z1, zz = 0; z < z1+z2; z++, zz++){
                    if(xx == yy && yy == zz && zz == xx)PutPixel(x, y, z, Color);
                }
            }
        }
}
void DrawBall(float x, float y, float z, float r, COL Color, bool f){
    for(float xx = x-r; xx < x+r; xx++){
        for(float yy = y-r; yy < y+r; yy++){
            for(float zz = z-r; zz < z+r; zz++){
                float a = ((xx-x)*(xx-x) + (yy-y)*(yy-y) + (zz-z)*(zz-z));
                if(f){
                    if(a < r*r )PutPixel(xx, yy, zz, Color);
                }
                else{
                    if(a >= r*r-30 && a < r*r)PutPixel(xx, yy, zz, Color);
                }
            }
        }
    }
}
void ShiftVRam(ShiftType Type){
    switch(Type){
        case X_Plus :
            for(int i = 55 ; i >= 0; i--){
                for(int j = 0;j < 3; j++){
                    VRam[i+8][j] = VRam[i][j];
                }
            }
            for(int i = 0 ; i < 8; i++){
                for(int j = 0;j < 3; j++){
                    VRam[i][j] = 0;
                }
            }
            break;
        case X_Minus :
            for(int i = 0 ; i < 56; i++){
                for(int j = 0;j < 3; j++){
                    VRam[i][j] = VRam[i+7][j];
                }
            }
            for(int i = 0 ; i < 8; i++){
                for(int j = 0;j < 3; j++){
                    VRam[i][j] = 0;
                }
            }
            break;
        case Z_Plus :
            for(int i = 0 ; i < 64; i++){
                for(int j = 0;j < 3; j++){
                    VRam[i][j] = VRam[i][j] << 1;
                }
            }
            break;
        case Z_Minus :
            for(int i = 0 ; i < 64; i++){
                for(int j = 0;j < 3; j++){
                    VRam[i][j] = VRam[i][j] >> 1;
                }
            }
            break;
    }
}
//VerticalProcessings---------------------------------
int VertCount = 0;
//uint64_t VertData = 1;
char VertDataArray[8] = {
    0,0,0,0,0,0,0,0
};
void IniVertArray(){
    for(int i = 0;i < 8; i++){
        VertDataArray[i] = 0;
    }
}
void VertNext(){
    if(VertCount >= 64){
        VertCount = 0;
    }
    VertCount++;
}
void WriteVertData(){
    SReg2.write(VertDataArray, 8);
}
void vertUpData(){
    IniVertArray();
    VertDataArray[VertCount/8] = 1 << VertCount%8;
}

//HorizonProcessings---------------------------------
//BRG
char HorizData[3] = {0x00, 0x00, 0x00};
void WriteHrizData(){
    SReg.write(HorizData, 3);
}
void horizUpData(bool F){
    if(F){
        for(int i = 0;i < 3; i++){
            HorizData[i] = VRam[VertCount][i];
        }
    }else{
        for(int i = 0;i < 3; i++){
            HorizData[i] = 0;
        }
    }
}

//FramePagingProcessings----------------------------------
long Frame = 0;
bool UpdateFlag = false;
void FrameUpDate(bool F){
    if(VertCount != 64){
        WriteVertData();
        WriteHrizData();
        vertUpData();
        horizUpData(F);
        if(F)VertNext();
    }
}

void InitialScreen(int n, char data){
    int temp = VertCount;
    VertCount = 0;
    IniVRam(data);
    for(int i = 0; i < n; i++){
        FrameUpDate(true);
    }
    VertCount = temp;
}
void Cls(){
    int temp = VertCount;
    VertCount-=1;
    FrameUpDate(false);
    VertCount = temp;
}

void CubeUpdata(){
    VertCount = 0;
    for(int i = 0; i <= 64; i++){
        FrameUpDate(true);
        Cls();
    }
}