#include "CubeObj.h"
#include<stdlib.h>

CubeObj::CubeObj(){
    x = 0;
    y = 0;
    z = 0;
    gz = 0;
    c = 0;
}
CubeObj::CubeObj(int sx, int sy, int sz, COL sc){
    set(sx, sy, sz, sc);
    ang[0] = 0;
    ang[1] = 0;
    sp = 0;
    gz = 0;
}
void CubeObj::set(int sx, int sy, int sz, COL sc){
    x = (double)sx;
    y = (double)sy;
    z = (double)sz;
    c = sc;
    ang[0] = 0;
    ang[1] = 0;
    sp = 0;
    gz = 0;
}
void CubeObj::set(double ang1, double ang2, double s){
    this->ang[0] = ang1;
    this->ang[1] = ang2;
    this->sp = s;
    gz = 0;
}
void CubeObj::go(int tx, int ty, int tz, double s){
    PutPixel(x, y, z, c);
    ang[0] = atan2(ty-y, tx-x);
    x += cos(ang[0]) * s;
    y += sin(ang[0]) * s;
    ang[1] = atan2(tz-z, tx-x);
    z += sin(ang[1]) * s;
    if(z <= -1 || z >= 8){
        c = 0;
    }
}
void CubeObj::go(double ang1, double ang2, double s){
    PutPixel(x, y, z, c);
    this->ang[0] = ang1;
    this->ang[1] = ang2;
    this->sp = s;
    x += cos(ang[0]) * sp;
    y += sin(ang[0]) * sp;
    z += sin(ang[1]) * sp;
}
void CubeObj::go(){
    PutPixel(x, y, z, c);
    x += cos(ang[0]) * sp;
    y += sin(ang[0]) * sp;
    z += sin(ang[1]) * sp;
}
void CubeObj::friction(double stp){
    sp /= stp;
} 
void CubeObj::gravity(double stp){
    gz += stp;
    z -= gz;
}
void CubeObj::leave(int tx, int ty, int tz, double s){
    PutPixel(x, y, z, c);
    ang[0] = atan2(ty-y, tx-x);
    x -= cos(ang[0]) * s;
    y -= sin(ang[0]) * s;
    ang[1] = atan2(tz-z, tx-x);
    z -= cos(ang[1]) * s;
    if(z <= -1 || z >= 8){
        c = 0;
    }
}

void CubeObj::draw(){
    PutPixel(x, y, z, c);
}