#include "mbed.h"
#include "CubeObj.h"
#include "FireWorkr.h"
#include "3DSnake.h"
#include<stdlib.h>

#define AnmeNum 6

int animeType = 0;
int animeCount = 0;
float amimationFrame[]={
    //BallImpact
    0.03,
    //FireWorks
    3,
    //Checks
    0.1,
    //Wave
    0.02,
    //Wave2
    0.02,
    //Snake
    0.1
};
int animationLoops[]={
    //BallImpact
    60,
    //FireWorks
    60,
    //Checks
    10,
    //Wave
    30,
    //Wave2
    30,
    //Snake
    60
};

Fireworks FW;
float c = 0;
int x, y, z, dc;

Snake Snake_(4,4,4, 7, 5);
int SnakeD = 0;

int CheckCount = 0;

Ticker animationTime;
Ticker frameud;
Ticker FShotT;
InterruptIn BPush(USER_BUTTON);
bool ShotFlag = true;
void Shot();
void animeTimeCount(){
    animeCount++;
    if(animeCount > animationLoops[animeType]){
        Snake_.color[1] = rand()%7+1;
        animeCount = 0;
        animeType = rand() % AnmeNum;
        dc = rand() % 7 + 1;
        FShotT.attach(&Shot, amimationFrame[animeType]);
    }
    
}
void Shot(){
    switch(animeType){
        //BallImpact----------------------------
        case 0 :
            c+=0.5f;
            if(c >= 16){
                c = 0;
                x = rand() % 8;
                y = rand() % 8;
                z = rand() % 8;
                dc = rand() % 7 + 1;
            }
        break;
        //FireWorks-----------------------------
        case 1 :
            ShotFlag = true;
        break;
        //Checks--------------------------------
        case 2 :
            CheckCount++;
            if(CheckCount > 8 * 3 * 3)CheckCount = 0;
        break;
        //Wave--------------------------------
        case 3 :
            if(CheckCount%2 == 0)ShiftVRam(Z_Minus);
            CheckCount++;
            if(CheckCount >= 32)CheckCount = 0;
        break;
        //Wave2--------------------------------
        case 4 :
            if(CheckCount%2 == 0)ShiftVRam(X_Plus);
            CheckCount++;
            if(CheckCount >= 32)CheckCount = 0;
        break;
        //Snake--------------------------------
        case 5 :
            if(rand()%2 == 0)SnakeD = rand()%12;
            Snake_.moveBody();
            Snake_.moveHead(SnakeD);
        break;
        
    }
}
 int S[32] = {4.780361288,5.530733729,6.222280932,6.828427125,7.325878449,7.69551813,7.923141122,8,7.923141122,7.69551813,7.325878449,6.828427125,6.222280932,5.530733729,4.780361288,4,3.219638712,2.469266271,1.777719068,1.171572875,0.674121551,0.30448187,0.076858878,0,0.076858878,0.30448187,0.674121551,1.171572875,1.777719068,2.469266271,3.219638712,4};        
void MainPrs(){
    switch(animeType){
        //BallImpact----------------------------
        case 0 :
            IniVRam(0);
            DrawBall(x,y,z, c, dc, false);
        break;
        //FireWorks-----------------------------
        case 1 :
            IniVRam(0);
            if(ShotFlag){
                ShotFlag = false;
                FW.isWork = false;
                FW.SetColor(rand()%7+1, rand()%7+1);
                FW.put(rand()%8, rand()%8, rand()%4+4);
                
            }
            else
                FW.Update();
        break;
        //Checks--------------------------------
        case 2 :
            IniVRam(0);
            int aa = CheckCount%8;
            COL cx;
            switch((CheckCount/8) % 3){
                case 0 :
                    cx = GetColor(1,0,0);
                    break;
                case 1 :
                    cx = GetColor(0,1,0);
                    break;
                case 2 :
                    cx = GetColor(0,0,1);
                    break;
            }
            switch(CheckCount/(8*3)){
                case 0 :
                    DrawBox(aa, 0, 0, 1, 8, 8, cx, true);
                    break;
                case 1 :
                    DrawBox(0, aa, 0, 8, 1, 8, cx, true);
                    break;
                case 2 :
                    DrawBox(0, 0, aa, 8, 8, 1, cx, true);
                    break;
            }
        break;
        //Wave----------------------------------
        case 3 :
            if(dc % 3 == 0){
                DrawBox(S[CheckCount],0,7, 1,8,1, dc,true);
            }else if(dc % 3 == 1){
                DrawBox(0,S[CheckCount],7, 8,1,1, dc,true);
            }else if(dc % 3 == 2){
                for(int i = 0; i < 8; i++)PutPixel((int)S[(CheckCount + (i*2))%32],i,7, dc);
            }
        break;
        //Wave2---------------------------------
        case 4 :
            int S[32] = {4.780361288,5.530733729,6.222280932,6.828427125,7.325878449,7.69551813,7.923141122,8,7.923141122,7.69551813,7.325878449,6.828427125,6.222280932,5.530733729,4.780361288,4,3.219638712,2.469266271,1.777719068,1.171572875,0.674121551,0.30448187,0.076858878,0,0.076858878,0.30448187,0.674121551,1.171572875,1.777719068,2.469266271,3.219638712,4};
            for(int i = 0; i < 8; i++)PutPixel(0,i,(int)S[(CheckCount + (i*2))%32], dc);
        break;
        //Snake---------------------------------
        case 5 :
            IniVRam(0);
            Snake_.drawHB();
        break;
    }
}
void PushButton(){
    animeType++;
    if(animeType >= AnmeNum)animeType = 0;
    animeCount = 0;
    dc = rand() % 7 + 1;
    FShotT.attach(&Shot, amimationFrame[animeType]);
}
int main(void) {
    frameud.attach(&MainPrs, 0.01);
    FShotT.attach(&Shot, amimationFrame[animeType]);
    animationTime.attach(&animeTimeCount,1);
    BPush.fall(&PushButton);
    while(1){
        CubeUpdata();
    }
}