#include "mbed.h"
#include "vt100.h"
#include "quattro.h"
#include "SEPS225.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "VEML6075.h"

#include "kinetis_raw128x128.h"

// dummy assign for RESET PIN
#define PIN_RESET_TFT PTC5

#define VEML6075_I2C_ADDRESS (0x10)

VEML6075  *veml6075 = 0 ;

SEPS225 TFT(SPI_8, 10000000, 
    PIN_OLED_MOSI, PIN_OLED_MISO,  PIN_OLED_SCLK, 
    PIN_OLED_CS, PIN_RESET_TFT, PIN_OLED_RS, "OLED SEPS225") ;
    
Serial pc(PTE0, PTE1) ;
vt100 *tty = 0 ;
int page = 0 ;
int prevPage = 0 ;
int numPages = 6 ;

void enableSW(void)
{  
    int3_r->enable_irq() ;
    int4_g->enable_irq() ;
    int5_b->enable_irq() ;
}

void disableSW(void)
{
    int3_r->disable_irq() ;
    int4_g->disable_irq() ;
    int5_b->disable_irq() ;
}

void swRPressed(void) 
{
    int3_r->disable_irq() ;
    *led3_org = !(*led3_org) ;
    page++ ;
    page %= numPages ;
    wait(0.25) ;
    int3_r->enable_irq() ;
}

void swGPressed(void) 
{
    int4_g->disable_irq() ;
    *led4_org = !(*led4_org) ;
    page = 0 ;
    wait(0.25) ;
    int4_g->enable_irq() ;
}

void swBPressed(void) 
{
    int5_b->disable_irq() ;
    *led5_org = !(*led5_org) ;
    page-- ;
    if (page < 0) {
        page = numPages - 1 ;
    }
    wait(0.25) ;
    int5_b->enable_irq() ;
}

void doLines(unsigned short color)
{
    TFT.cls() ;
    for (int i = 0 ; i < 128 ; i += 8) {
        TFT.line(i, 0, 127-i, 127, color) ;
    }
}

void doCircles(unsigned short color)
{
    TFT.cls() ;
    for (int i = 0 ; i < 64 ; i+= 4) {
        TFT.circle(64, 64, i, color) ;
    }
}

void doRects(unsigned short color)
{

*oled_cs = 0 ;
    TFT.cls() ;
    TFT.line(32, 32, 100, 100, color) ;
    TFT.rect(32, 32, 100, 100, color) ;
/*
    for (i = 0 ; i < 64 ; i += 4) {
       x0 = 64 - i ;
       x1 = 64 + i ;
       y0 = 64 - i ;
       y1 = 64 + i ;
       TFT.rect(x0, y0, x1, y1, color) ;
    }
*/
*oled_cs = 1 ;
}

void doText(void)
{
    TFT.cls() ;
// *oled_cs = 0 ;
//    TFT.line(0, 64, 127, 64, 0xFF00) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(0xFFFF) ;
    TFT.background(0x0000) ;
    TFT.locate(10, 20) ;
    TFT.printf("MBED") ;
    TFT.foreground(0xFFFF);
    TFT.locate(20, 60) ;
    TFT.printf("2.8\"TFT") ;
    TFT.locate(20, 80) ;
    TFT.printf("ABCDEF") ;

// *oled_cs = 1 ; 
}

void doSplash(void)
{
    TFT.cls() ;
    TFT.foreground(0xFFFF) ;
    TFT.background(0x0000) ;
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.locate(5, 5) ;
    TFT.printf("Marubun") ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(35, 40) ;
    TFT.printf("quattro-II") ;
    TFT.locate(50, 60) ;
    TFT.printf("&") ;
    TFT.locate(40, 80) ;
    TFT.printf("shaft-II") ;
    TFT.foreground(0xFD20) ;
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(10, 100) ;
    TFT.printf("Kinetis") ;
    TFT.foreground(0xFFFF) ;
    TFT.set_font((unsigned char*) Arial12x12);
}

void doPict(unsigned short pict[])
{
    int x, y ;
    TFT.display(0) ;   
//    TFT.window(0, 0, 127, 127) ;
    TFT.cls() ;
    for (y = 0 ; y < 128 ; y++ ) {
        for (x = 0 ; x < 128 ; x++ ) {
            TFT.pixel(x, y, pict[128*y + x]) ;
        }
    }
//    TFT.window_pushpixelbuf(pict, 128*128) ;
    TFT.display(1) ;
}

void init_sensors(void)
{
    veml6075 = new VEML6075(PTB3, PTB2, VEML6075_I2C_ADDRESS) ; // for FRDM-K22F 
    veml6075->setUVConf(0x00) ;
//    veml6040 = new VEML6040(PTB3, PTB2, VEML6040_I2C_ADDRESS) ; // for FRDM-K22F 
//    veml6040->setCOLORConf(0x00) ;
}

void reportVEML6075(VEML6075 *veml,int x, int y)
{
    uint8_t uvconf = 0x00 ;
    uint16_t id = 0 ;
    uint16_t uvadata = 0 ;
    uint16_t uvbdata = 0 ;
    uint16_t uvcomp1data = 0 ;
    uint16_t uvcomp2data = 0 ;
    float fUVA = 0.0 ;
    float fUVA_CIE = 0.0 ;
    float fUVB = 0.0 ;
    float fUVB_CIE = 0.0 ;
    float uvi = 0 ;
 
    veml6075->setUVConf(uvconf) ;
    veml6075->getUVConf(&uvconf) ;
    veml6075->getID(&id) ;
    
    veml6075->getUVAData(&uvadata) ;
    veml6075->getUVBData(&uvbdata) ;
    veml6075->getUVCOMP1Data(&uvcomp1data) ;
    veml6075->getUVCOMP2Data(&uvcomp2data) ;
    fUVA = veml6075->getUVA() ;
    fUVA_CIE = veml6075->getUVA_CIE() ;
    fUVB = veml6075->getUVB() ;
    fUVB_CIE = veml6075->getUVB_CIE() ;
    uvi = veml6075->UVI() ;
    
    TFT.foreground(White);
    TFT.locate(x+30, y) ;
    TFT.printf("VEML6075\n") ;
    TFT.locate(x, y+10) ;
    TFT.printf("ID = 0x%04X\n", id) ;
    TFT.locate(x, y+20) ;
    TFT.printf("uvconf = 0x%02X\n", uvconf) ;
    TFT.locate(x, y+40) ;
    TFT.printf("UVLED:NCSU033X\n") ;
    TFT.locate(x, y+50) ;
    TFT.printf("UVA [%08.2f uW/cm2]\n", fUVA ) ;
//    TFT.locate(x, y+50) ;
//    TFT.printf("UVA [%.7f W/m2]\n", fUVA_CIE ) ;
    TFT.locate(x, y+70) ;
    TFT.printf("UVLED:UVTOP310TO39HS\n") ;
    TFT.locate(x, y+80) ;
    TFT.printf("UVB [%08.2f uW/cm2]\n", fUVB ) ;
//    TFT.locate(x, y+80) ;
//    TFT.printf("UVB [%.7f W/m2]\n", fUVB_CIE ) ;
    TFT.locate(x, y+100) ;
    if (uvi >= 8.0 )
    TFT.foreground(Red);
    else if (uvi < 8.0 && uvi > 3.0 )
    TFT.foreground(Yellow);
    else
    TFT.foreground(White);
//    TFT.printf("UVI [ %.1f ]  for Demo\n", uvi ) ; // For demo
    TFT.printf("UVI [ %.1f ] \n", uvi ) ;
//    TFT.printf("comp1 [ %6d ]", uvcomp1data) ;
//    TFT.printf("comp2 [ %6d ]", uvcomp2data) ;
}

void doReportVeml(void)
{
    if (prevPage != page) {
       TFT.cls() ;
       wait(0.5) ;
    }
    TFT.set_font((unsigned char*) Terminal6x8);
    reportVEML6075(veml6075, 5, 10) ;
//    reportVEML6040(veml6040, 5, 10) ;
}

void drawUVIArrow(float value, uint16_t color)
{
    int x, y ;
    x = 116 ;
    y = 110 - (value * 8.0) ;
    if (y > 108) y = 108 ;
    if (y < 17) y = 17 ;
    TFT.line(x, y, x+7, y, color) ;
    TFT.line(x, y, x+2, y-2, color) ;
    TFT.line(x, y, x+2, y+2, color) ;
}
/*
 * UV index
 * 11~ Extreme
 * 8~10 Very High
 * 6~7 High
 * 3~5 Moderate
 * 0~2 Low
 */
void drawUVIFrame(void)
{
    int x, y, i ;
    uint16_t color ;
     
    TFT.set_font((unsigned char*) Terminal6x8);
    
    TFT.rect(0, 0, 127, 111, White) ;
    TFT.line(32, 0, 32, 111, White) ;
    TFT.line(96, 0, 96, 111, White) ;
    TFT.line(0, 16, 127, 16, White) ;
    color = Purple ;
    TFT.fillrect(33, 17, 95,  33, color) ; /* extreme */
    TFT.locate(44, 21) ; TFT.background(color) ;
    TFT.printf("Extreme") ;
    color = Red ;
    TFT.fillrect(33, 34, 95,  54, color) ;
    TFT.locate(38, 40) ; TFT.background(color) ;
    TFT.printf("Very High") ;
    color = Orange ;
    TFT.fillrect(33, 55, 95,  70, color) ;
    TFT.locate(50, 59) ; TFT.background(color) ;
        TFT.foreground(Black) ;
    TFT.printf("High") ;
    color = Yellow ;
    TFT.fillrect(33, 71, 95,  95, color) ;
    TFT.locate(40, 79) ; TFT.background(color) ;
    TFT.printf("Moderate") ;

    color = Green ;
    TFT.fillrect(33, 96, 95, 110, color) ;
    TFT.locate(56, 100) ; TFT.background(color) ;
    TFT.printf("Low") ;
    
    TFT.foreground(White) ;    
    TFT.background(Black) ;
    TFT.locate(10, 6) ;
    TFT.printf("Ee") ;
    TFT.locate(40, 6) ;
    TFT.printf("Strength") ;
    TFT.locate(102, 6) ;
    TFT.printf("UVI") ;

    i = 1 ;
    for (y = 111 - 8 ; y > 16 ; y -= 8) {
        TFT.line(28, y, 34, y, White) ;
        TFT.line(94, y, 100, y, White) ;
        TFT.locate(102, y-4) ; TFT.printf("%2d",i) ;
        i++ ;
    }
    TFT.locate(8, 100) ; TFT.printf("0.0") ;
    TFT.locate(8, 76)  ; TFT.printf("0.1") ;
    TFT.locate(8, 46)  ; TFT.printf("0.2") ;
    TFT.locate(8, 18)  ; TFT.printf("0.3") ;
}

void drawVemlUVI(void)
{
    uint8_t uvconf = 0x00 ;
    float uvi = 0 ;
    static float prev_uvi = 0 ;
 
    veml6075->setUVConf(uvconf) ;
    veml6075->getUVConf(&uvconf) ;
    uvi = veml6075->UVI() ;
    
    TFT.set_font((unsigned char*) Terminal6x8);
    TFT.locate(16, 117) ; 
    TFT.printf("UV Index = %2.3f", uvi) ;
    drawUVIArrow(prev_uvi, Black) ;
    drawUVIArrow(uvi, White) ;
    prev_uvi = uvi ;
}

void doDrawUVI(void)
{
    if (prevPage != page) {
       TFT.cls() ;
       wait(0.5) ;
       drawUVIFrame() ;
    }
    drawVemlUVI() ;
}

double clip(double src)
{
    double value ;
    value = src ;
    if (value < 0.0) {
        value = 0.0 ;
    } else if (value > 2.0) {
        value = 2.0 ;
    }
    return( value ) ;
}

void updatePage(void)
{
    switch(page) {
    case 0: // splash
        if (page != prevPage) {
            doSplash() ;
        }
        break ;
    case 1:
        if (page != prevPage) {
            doPict(kinetis_logo) ;
        }
        break ;
    case 2:
          doReportVeml() ;
        break ;
    case 3:
        doDrawUVI() ;
        break ;
    default:
        page = 0 ;
        doPict(kinetis_logo) ;
        break ;
    }
    prevPage = page ;
}

int main()
{
    oled_cs = new DigitalOut(PIN_OLED_CS, 1) ;
    oled_rs = new DigitalOut(PIN_OLED_RS, 1) ;
    tty = new vt100() ;
    tty->cls() ;
    
    init_quattro() ;
    int3_r->fall(swRPressed) ;
    int4_g->fall(swGPressed) ;
    int5_b->fall(swBPressed) ;
    
    init_sensors() ;
    
    printf("quattro (%s)\n\r", __DATE__) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.window(0,0,128,128) ;
    
    doSplash() ; 
    page = 0 ;
    prevPage = 0 ;
    TFT.display(1) ;

    wait(1) ;
    while(1) {
        disableSW() ;
        updatePage() ;
        enableSW() ;
        wait(0.1) ;
    }
}
