// PYROCOMMANDER
// STM32F746NG
#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "stm32746g_discovery_lcd.h"
#include "TS_DISCO_F746NG.h"
#include "fonts.h"
//#include "Digital11x17.h" 

#define FramesPerSecond 25

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

DigitalOut led1(LED1);

char textBuf[12];
char getal [10];
int h = 0;
int m = 0;
int s = 0;
int f = 0;
unsigned long FRAMES_IN_HOUR = 3600 * FramesPerSecond;
unsigned long FRAMES_IN_MINUTE = 60 * FramesPerSecond;
unsigned long x = 0;


int main()
{
//    lcd.Font (digital11x17);
    led1 = 1;
    lcd.Clear(LCD_COLOR_DARKBLUE);
    lcd.SetBackColor(LCD_COLOR_DARKBLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font16);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"www.Pyrocommander.com", CENTER_MODE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DrawRect(1, 1, 478, 270);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_YELLOW);
    lcd.SetFont(&Font8);
    lcd.DisplayStringAt(20, LINE(30), (uint8_t *)"Rdk Systems", RIGHT_MODE);
    lcd.SetBackColor(LCD_COLOR_DARKBLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(20, LINE(5), (uint8_t *)"Actual Time :", LEFT_MODE);
    lcd.SetBackColor(LCD_COLOR_DARKBLUE);
    lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);
    lcd.SetFont(&Font16);
    lcd.DisplayStringAt(90, LINE(12), (uint8_t *)"Total Frames :", LEFT_MODE);
    lcd.SetBackColor(LCD_COLOR_DARKRED);
    lcd.SetTextColor(LCD_COLOR_YELLOW);
    lcd.SetFont(&Font24);

    while(1) {
        wait_ms (40);
        x++;
        h = (int) (x / FRAMES_IN_HOUR);
        m = (int) ((x % FRAMES_IN_HOUR) / FRAMES_IN_MINUTE);
        s = (int) (((x % FRAMES_IN_HOUR) % FRAMES_IN_MINUTE) / FramesPerSecond);
        f = (((x % FRAMES_IN_HOUR) % FRAMES_IN_MINUTE) % FramesPerSecond);

        sprintf(textBuf,"%02d:%02d:%02d:%02d", h,m,s,f);
        sprintf(getal,"%010d", x);

        lcd.SetBackColor(LCD_COLOR_DARKGREEN);
        lcd.SetTextColor(LCD_COLOR_YELLOW);
        lcd.SetFont(&Font24);
        lcd.DisplayStringAt(270, LINE(5), (uint8_t *)textBuf, LEFT_MODE);
        lcd.SetBackColor(LCD_COLOR_DARKBLUE);
        lcd.SetTextColor(LCD_COLOR_YELLOW);
        lcd.SetFont(&Font16);
        lcd.DisplayStringAt(270, LINE(12), (uint8_t *) getal, LEFT_MODE);

        led1 = !led1;
    }
}
