#include "mbed.h"
#include "AnalogIn.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX);
AnalogIn externo(PTC2);
AnalogIn interno(PTB3);

TextLCD lcd(PTD3, PTA12, PTA4, PTA5, PTC8, PTC9, TextLCD::LCD16x2);

int temp = 26;

void recibedato(){
    pc.scanf("%d", &temp);
    pc.printf("se seteo la temperatura a %.0d\r\n", temp);
    }

int main() {
  
    pc.baud(115200);
    pc.attach(&recibedato);

    float casinterno;
    float casexterno;
    float tinterno;
    float texterno;
    int comp;

    while(1){
        lcd.cls();
        casexterno = externo.read() * 3.3;
        texterno = (casexterno + 0.2) * 100 / 5;
        
        casinterno = interno.read() * 3.3;
        tinterno = (casinterno + 2) * 100 / 8;
        
        lcd.printf("int %.1f set %d",tinterno, temp);
        lcd.locate(0,1);
        lcd.printf("ext %.1f", texterno);
        comp = tinterno;
        if(comp == temp)
            pc.printf("las temperaturas son iguales\n\r");
        else
            pc.printf("temperaturas distintas\n\r");
        wait(1);
    }
}