#include "mbed.h"
#include "TextLCD.h"
#include "AnalogIn.h"

Serial pc(USBTX, USBRX);
TextLCD lcd(PTD3, PTA12, PTA4, PTA5, PTC8, PTC9, TextLCD::LCD16x2);

Timer t;
DigitalIn key1(PTE31);
DigitalIn key2(PTE19);
DigitalIn key3(PTE18);
DigitalIn key4(PTE17);
InterruptIn Enable(PTA13);
AnalogIn externo(PTC2);
AnalogIn interno(PTB3);

int temp = 26;
char tipo;
int sel = 1;
float casinterno;
float casexterno;
float tinterno;
float texterno;
char modo = 'M';
int set = 0;
int pdig, sdig, val;
int i = 0;
int tipobanio = 0;
int tempauto=0;
int hora=0, min=0, seg=0, horain = 8, minin = 0, horafin = 22, minfin = 0, j = 0;
int B1,B2,B3,B4,num;
int hh1,hh0,mm0,mm1;

void menu();
void selec();
void func();

void sethora(){
    if(i == 0) {                        //set de primer digito hora
                    if(num > 2){
                        lcd.locate(0,0);
                        lcd.printf("valor invalido");
                        wait(.7);
                        func();
                        }
                    else{
                        hh1 = num;
                        lcd.cls();
                        lcd.printf("%dx:xx",hh1);
                        lcd.locate(0,1);
                        lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                        wait(.7);   
                        i++;}}else                            //fin de set 1er digito hora ok
                    if(i == 1){
                        pc.printf("aca ingresaria 2 dig hora\n\r"); //inicio 2do digito hora
                        if(hh1 == 2 && num > 4){
                            lcd.locate(0,0);
                            lcd.printf("valor invalido");
                            wait(.7);
                            func();
                        }else{
                        hh0 = num;
                        lcd.cls();
                        lcd.printf("%d%d:xx",hh1,hh0);
                        lcd.locate(0,1);
                        lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                        wait(.7);   
                        i++;}
                        }else                                       //fin 2do digito hora 
                    if(i == 2){
                        pc.printf("aca ingresaria 1 dig seg\n\r");  //inicio 1er digito minuto
                            if(num > 6){
                                lcd.locate(0,0);
                                lcd.printf("valor invalido");
                                wait(.7);
                                func();
                            }else{
                                mm1 = num;
                                lcd.cls();
                                lcd.printf("%d%d:%dx",hh1,hh0,mm1);
                                lcd.locate(0,1);
                                lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                                wait(.7); 
                                i++;}
                        }else                                       //fin 2do digito minuto
                    if(i == 3){
                        pc.printf("aca ingresaria 2 dig seg\n\r");  //inicio 2do digito minuto
                        if(mm1 == 6){
                                mm0 = 0;
                            }else{
                                mm0 = num;
                                }
                                lcd.cls();
                                lcd.printf("%d%d:%d%d",hh1,hh0,mm1,mm0);
                                lcd.locate(0,1);
                                lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                                i++;
                        
                        }                                                   //fin 2do digito minuto 
    }
void imprimehora(){
        lcd.locate(11,1);
        if(min < 10 && hora >= 10)
        lcd.printf("%2i:0%i", hora, min);
        if(hora < 10 && min >= 10)
        lcd.printf("0%i:%2i", hora, min);
        if(hora < 10 && min < 10)
        lcd.printf("0%i:0%i", hora, min);
        if(hora >= 10 && min >= 10)   
        lcd.printf("%i:%i", hora, min);
        }

void func()
{
    B1 = key1.read();
    B2 = key2.read();
    B3 = key3.read();
    B4 = key4.read();

    num = 2*2*2*B1 + 2*2*B2 + 2*B3 + B4;
    pc.printf("llama a func\n\r");
    if(num == 10) {
        set = 0;
        menu();
    } else if(num == 11) {
        set = 0;
        selec();
    } else if(num != 10 && num != 11) {

        pc.printf("antes del case\n\r");
        switch(set) {
            case 0:
                pc.printf("case 0");
                break;
            case 1:                                 //seteo hora
                        sethora();                           
                        if(i == 4) {                                        //pasa la hora al reloj
                            hora = (hh1 * 10) + hh0;
                            min = (mm1 * 10) + mm0;
                            hh0 = hh1 = mm1 = mm0 = 0;
                            t.start();
                            lcd.locate(0,0);
                            lcd.printf("reloj          ");
                            lcd.locate(0,1);
                            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                            i = 0;}
                break;                                                          //fin pasa hora al reloj
            case 2:
                 pc.printf("ingreso temperaturas de auto\n\r");                    //set temperaturas auto                
                if(num == 0 || num == 1 || num == 2) {
                    tempauto = num;
                    lcd.locate(0,0);
                    if(num == 0)
                        lcd.printf("tipo frio    ");
                    else if(num == 1)
                        lcd.printf("tipo normal  ");
                        else
                            lcd.printf("tipo caliente");
                    wait(1);
                    lcd.cls();
                    lcd.printf("temperatura");
                    set = 0;
                } else {
                    lcd.locate(0,0);
                    lcd.printf("valor invalido");
                    wait(1);
                    lcd.printf("tipo banio");
                    lcd.cls();
                }
                break;
            case 3:                                                         //tipo de baño
                pc.printf("ingreso tipo banio %d\n\r",num);
                if(num == 0 || num == 1) {
                    tipobanio = num;
                    lcd.locate(0,0);
                    if(num == 0)
                        lcd.printf("banio rapido  ");
                    else
                        lcd.printf("banio normal  ");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                    pc.printf("%.1d\n\r", tipobanio);
                    set = 0;
                } else {
                    lcd.locate(0,0);
                    lcd.printf("valor invalido");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                }
                break;
            case 4:                                                 //set de horarios                                            
                pc.printf("case 4\n\r");
                sethora();                           
                        if(i == 4 && j == 0) {                                        //pasa la hora al reloj
                            horain = (hh1 * 10) + hh0;
                            minin = (mm1 * 10) + mm0;
                            hh0 = hh1 = mm1 = mm0 = 0;
                            lcd.locate(0,0);
                            lcd.printf("horario         ");
                            lcd.locate(0,1);
                            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                            pc.printf("hora de inicio %d:%d\n\r",horain,minin);
                            pc.printf("hora de fin %d:%d\n\r",horafin,minfin);
                            i = 0;
                            j = 1;}
                        if(i == 4 && j == 1) {                                        //pasa la hora al reloj
                            horafin = (hh1 * 10) + hh0;
                            minfin = (mm1 * 10) + mm0;
                            hh0 = hh1 = mm1 = mm0 = 0;
                            lcd.locate(0,0);
                            lcd.printf("horario         ");
                            lcd.locate(0,1);
                            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                            pc.printf("hora de inicio %d:%d\n\r",horain,minin);
                            pc.printf("hora de fin %d:%d\n\r",horafin,minfin);
                            i = 0;
                            j = 0;}
                break;
            case 5:                                                 //set temperatura manual
                if(i == 0) {
                    pdig = num;
                    pc.printf("%.1d\n\r", pdig);
                } else if(i == 1) {
                    sdig = num;
                    pc.printf("%.1d\n\r", sdig);
                    val = (pdig * 10) + sdig;
                    pc.printf("%.1d\n\r", val);
                    imprimehora();
                    lcd.locate(0,0);
                    lcd.printf("temperatura a %d",val);
                    wait(1);
                    lcd.locate(0,0);
                    lcd.printf("temperatura     ");
                }
                i++;
                if(i == 2) {
                    i = 0;
                }
                break;
            case 6:                                                     //tipo de banio manual
                pc.printf("ingreso tipo banio %d\n\r",num);
                if(num == 0 || num == 1) {
                    tipobanio = num;
                    lcd.locate(0,0);
                    if(num == 0)
                        lcd.printf("banio rapido  ");
                    else
                        lcd.printf("banio normal  ");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                    pc.printf("%.1d\n\r", tipobanio);
                    set = 0;
                } else {
                    lcd.locate(0,0);
                    lcd.printf("valor invalido");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                }
                break;
        }
        pc.printf("salgo case\n\r");
        pc.printf("%d",i);
    }
}

void menu ()
{
    lcd.cls();
    imprimehora();  
    switch (sel) {
        case 1:
            lcd.locate(0,0);
            lcd.printf("auto");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 2;
            break;
        case 2:
            lcd.locate(0,0);
            lcd.printf("manual");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 3;
            break;
        case 3:
            lcd.locate(0,0);
            lcd.printf("reloj");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 1;
            break;
        case 4:
            lcd.locate(0,0);
            lcd.printf("temperatura");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 5;
            break;
        case 5:
            lcd.locate(0,0);
            lcd.printf("tipo banio  ");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 6;
            break;
        case 6:
            lcd.locate(0,0);
            lcd.printf("horarios");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 9;
            break;
        case 7:
            lcd.locate(0,0);
            lcd.printf("temperatura");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 8;
            break;
        case 8:
            lcd.locate(0,0);
            lcd.printf("tipo banio  ");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 10;
            break;
        case 9:
            lcd.locate(0,0);
            lcd.printf("salir");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 4;
            break;
        case 10:
            lcd.locate(0,0);
            lcd.printf("salir");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 7;
            break;
    }
}


void selec()
{
    switch (sel) {
        case 2:
            modo = 'A';
            sel = 4;
            menu();
            break;
        case 3:
            modo = 'M';
            sel = 7;
            menu();
            break;
        case 1:
            pc.printf("aca ingresaria la hora\r\n");
            set = 1;
            break;
        case 5:
            pc.printf("aca ingresaria la temperatura\r\n");
            lcd.locate(0,0);
            lcd.printf(" 0_F 1_N 2_C");
            set = 2;
            break;
        case 6:
            pc.printf("aca ingresaria el tipo de banio\r\n");
            lcd.locate(0,0);
            lcd.printf(" 0_rap 1_norm");
            set = 3;
            break;
        case 4:
            sel = 1;
            menu();                    //salida1
            break;
        case 8:
            pc.printf("aca ingresaria la temperatura2\r\n");
            lcd.locate(0,0);
            lcd.printf("ingrese temperat");
            set = 5;
            break;
        case 7:
            sel = 2;
            menu();
            break;
        case 9:
            pc.printf("aca ingresaria el horario\r\n");
            set = 4;
            break;
        case 10:
            pc.printf("aca ingresaria tipo banio\r\n");
            lcd.locate(0,0);
            lcd.printf(" 0_rap 1_norm");
            set = 6;
            break;
    }

}


int main()
{
    t.start();
    pc.baud(115200);
    Enable.rise(&func);

    int comp;
    while(1) {
//reloj
    seg = t.read();
        if(seg == 60)
        {
            seg=0;
            t.reset();
            min++;   
        }
        if(min==60)
        {
            min=0;
            hora++; 
        }
        if(hora==24)
        {
            hora=0;}
        imprimehora();            
        
//convierte voltaje a temperatura
        casexterno = externo.read() * 3.3;
        texterno = (casexterno + 0.2) * 100 / 5;
        casinterno = interno.read() * 3.3;
        tinterno = (casinterno + 2) * 100 / 8;

        lcd.locate(0,1);
        lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
        comp = tinterno;
        if(comp == temp)
            pc.printf("las temperaturas son iguales\n\r");
        else
            pc.printf("temperaturas distintas\n\r");
        wait(1);
    }
}